/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli.devserver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.DefaultParser;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.Option;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.backend.javascript.JSModuleType;
import org.teavm.cli.devserver.JsonCommandReader;
import org.teavm.cli.devserver.JsonCommandWriter;
import org.teavm.common.json.JsonParser;
import org.teavm.devserver.DevServer;
import org.teavm.devserver.DevServerListener;
import org.teavm.tooling.ConsoleTeaVMToolLog;
import org.teavm.tooling.TeaVMToolLog;

public final class TeaVMDevServerRunner {
    private static Options options = new Options();
    private DevServer devServer;
    private CommandLine commandLine;
    private JsonCommandWriter jsonWriter;

    private static void setupOptions() {
        options.addOption(Option.builder((String)"d").argName("directory").hasArg().desc("a directory, relative to server's root, which serves generated files").longOpt("targetdir").build());
        options.addOption(Option.builder((String)"f").argName("file").hasArg().desc("a file where to put decompiled classes (classes.js by default)").longOpt("targetfile").build());
        options.addOption(Option.builder((String)"p").argName("classpath").hasArgs().desc("classpath element (either directory or jar file)").longOpt("classpath").build());
        options.addOption(Option.builder((String)"s").argName("sourcepath").hasArgs().desc("source path (either directory or jar file which contains source code)").longOpt("sourcepath").build());
        options.addOption(Option.builder().argName("classnames").hasArgs().desc("list of classes that should be preserved during the build (e.g. to use with reflection)").longOpt("preserved-classes").build());
        options.addOption(Option.builder().valueSeparator().hasArgs().longOpt("property").build());
        options.addOption(Option.builder().argName("module_type").hasArg().longOpt("js-module-type").desc("JS module type (umd, common-js, es2015 or none)").build());
        options.addOption(Option.builder().argName("number").hasArg().desc("port (default is 9090)").longOpt("port").build());
        options.addOption(Option.builder((String)"i").desc("display indicator on web page").longOpt("indicator").build());
        options.addOption(Option.builder().desc("deobfuscate stack traces").longOpt("deobfuscate-stack").build());
        options.addOption(Option.builder().desc("automatically reload page when compilation completes").longOpt("auto-reload").build());
        options.addOption(Option.builder((String)"v").desc("display more messages on server log").longOpt("verbose").build());
        options.addOption(Option.builder().argName("URL").hasArg().desc("delegate requests to URL").longOpt("proxy-url").build());
        options.addOption(Option.builder().argName("path").hasArg().desc("delegate requests from path").longOpt("proxy-path").build());
        options.addOption(Option.builder().desc("don't watch file system changes").longOpt("no-watch").build());
        options.addOption(Option.builder().desc("JSON interface over stdout").longOpt("json-interface").build());
    }

    private TeaVMDevServerRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.devServer = new DevServer();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        TeaVMDevServerRunner runner = new TeaVMDevServerRunner(commandLine);
        runner.parseArguments();
        runner.devServer.start();
        if (runner.jsonWriter != null) {
            runner.readStdinCommands();
        } else {
            try {
                runner.devServer.awaitServer();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void parseArguments() {
        this.parseClassPathOptions();
        this.parseSourcePathOptions();
        this.parseOutputOptions();
        this.devServer.setIndicator(this.commandLine.hasOption("indicator"));
        this.devServer.setDeobfuscateStack(this.commandLine.hasOption("deobfuscate-stack"));
        this.devServer.setReloadedAutomatically(this.commandLine.hasOption("auto-reload"));
        if (this.commandLine.hasOption("port")) {
            try {
                this.devServer.setPort(Integer.parseInt(this.commandLine.getOptionValue("port")));
            }
            catch (NumberFormatException e) {
                System.err.println("port must be numeric");
                TeaVMDevServerRunner.printUsage();
            }
        }
        Properties properties = this.commandLine.getOptionProperties("property");
        for (String property : properties.stringPropertyNames()) {
            this.devServer.getProperties().put(property, properties.getProperty(property));
        }
        if (this.commandLine.hasOption("preserved-classes")) {
            this.devServer.getPreservedClasses().addAll(List.of(this.commandLine.getOptionValues("preserved-classes")));
        }
        if (this.commandLine.hasOption("js-module-type")) {
            JSModuleType type;
            String moduleTypeValue = this.commandLine.getOptionValue("js-module-type");
            try {
                type = JSModuleType.valueOf((String)moduleTypeValue.toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid value for --js-module-type: " + moduleTypeValue);
                TeaVMDevServerRunner.printUsage();
                type = null;
            }
            this.devServer.setJsModuleType(type);
        }
        if (this.commandLine.hasOption("proxy-url")) {
            this.devServer.setProxyUrl(this.commandLine.getOptionValue("proxy-url"));
        }
        if (this.commandLine.hasOption("proxy-path")) {
            this.devServer.setProxyPath(this.commandLine.getOptionValue("proxy-path"));
        }
        if (this.commandLine.hasOption("no-watch")) {
            this.devServer.setFileSystemWatched(false);
        }
        if (this.commandLine.hasOption("json-interface")) {
            this.setupJsonInterface(this.devServer);
        } else {
            this.devServer.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog(this.commandLine.hasOption('v')));
        }
        String[] args = this.commandLine.getArgs();
        if (args.length != 1) {
            System.err.println("Unexpected arguments");
            TeaVMDevServerRunner.printUsage();
        } else {
            this.devServer.setMainClass(args[0]);
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.devServer.setPathToFile(this.commandLine.getOptionValue("d"));
        }
        if (this.commandLine.hasOption("f")) {
            this.devServer.setFileName(this.commandLine.getOptionValue("f"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.devServer.setClassPath(this.commandLine.getOptionValues('p'));
        }
    }

    private void parseSourcePathOptions() {
        if (this.commandLine.hasOption('s')) {
            this.devServer.getSourcePath().addAll(Arrays.asList(this.commandLine.getOptionValues('s')));
        }
    }

    private void setupJsonInterface(DevServer devServer) {
        this.jsonWriter = new JsonCommandWriter();
        devServer.setLog((TeaVMToolLog)this.jsonWriter);
        devServer.addListener((DevServerListener)this.jsonWriter);
        devServer.setCompileOnStartup(false);
        devServer.setLogBuildErrors(false);
        Log.setLog((Logger)this.jsonWriter);
    }

    private void readStdinCommands() {
        JsonCommandReader commandReader = new JsonCommandReader(this.devServer);
        JsonParser parser = JsonParser.ofValue((Consumer)commandReader);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
            String command;
            while ((command = reader.readLine()) != null) {
                parser.parse((Reader)new StringReader(command));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMDevServerRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMDevServerRunner.setupOptions();
    }
}

