/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TDictionary;
import org.teavm.classlib.java.util.TEnumeration;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TMapEntry;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TSet;

public class THashtable<K, V>
extends TDictionary<K, V>
implements TMap<K, V>,
TCloneable,
TSerializable {
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot;
    transient int lastSlot = -1;
    transient int modCount;
    private static final TEnumeration<?> EMPTY_ENUMERATION = new TEnumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new TNoSuchElementException();
        }
    };
    private static final TIterator<?> EMPTY_ITERATOR = new TIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new TNoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private static <K, V> Entry<K, V> newEntry(K key, V value, int hash) {
        return new Entry<K, V>(key, value);
    }

    public THashtable() {
        this(11);
    }

    public THashtable(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public THashtable(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.firstSlot = capacity;
        this.elementData = this.newElementArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = loadFactor;
        this.computeMaxSize();
    }

    public THashtable(TMap<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 4 / 3 + 11);
        this.putAll(map);
    }

    private Entry<K, V>[] newElementArray(int size) {
        return new Entry[size];
    }

    @Override
    public synchronized void clear() {
        this.elementCount = 0;
        Arrays.fill(this.elementData, null);
        ++this.modCount;
    }

    @Override
    public synchronized Object clone() {
        try {
            THashtable hashtable = (THashtable)super.clone();
            hashtable.elementData = new Entry[this.elementData.length];
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                if (entry == null) continue;
                hashtable.elementData[i] = (Entry)entry.clone();
            }
            return hashtable;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new TNullPointerException();
        }
        int i = this.elementData.length;
        while (--i >= 0) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.value.equals(value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized TEnumeration<V> elements() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator<Object>(entry -> entry.value, true);
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new TAbstractSet<TMap.Entry<K, V>>(){

            @Override
            public int size() {
                return THashtable.this.elementCount;
            }

            @Override
            public void clear() {
                THashtable.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    THashtable.this.remove(((TMap.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Entry entry = THashtable.this.getEntry(((TMap.Entry)object).getKey());
                return object.equals(entry);
            }

            @Override
            public TIterator<TMap.Entry<K, V>> iterator() {
                return new HashIterator(entry -> entry);
            }
        };
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TMap) {
            TMap map = (TMap)object;
            if (this.size() != map.size()) {
                return false;
            }
            TSet<TMap.Entry<K, V>> entries = this.entrySet();
            TIterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                TMap.Entry e = (TMap.Entry)iter.next();
                if (entries.contains(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry<K, V> getEntry(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (entry.equalsKey(key, hash)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized int hashCode() {
        int result = 0;
        TIterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            TMap.Entry entry = (TMap.Entry)it.next();
            Object key = entry.getKey();
            if (key == this || (value = entry.getValue()) == this) continue;
            int hash = (key != null ? key.hashCode() : 0) ^ (value != null ? value.hashCode() : 0);
            result += hash;
        }
        return result;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public synchronized TEnumeration<K> keys() {
        if (this.elementCount == 0) {
            return EMPTY_ENUMERATION;
        }
        return new HashEnumIterator<Object>(entry -> entry.key, true);
    }

    @Override
    public TSet<K> keySet() {
        return new TAbstractSet<K>(){

            @Override
            public boolean contains(Object object) {
                return THashtable.this.containsKey(object);
            }

            @Override
            public int size() {
                return THashtable.this.elementCount;
            }

            @Override
            public void clear() {
                THashtable.this.clear();
            }

            @Override
            public boolean remove(Object key) {
                if (THashtable.this.containsKey(key)) {
                    THashtable.this.remove(key);
                    return true;
                }
                return false;
            }

            @Override
            public TIterator<K> iterator() {
                if (this.size() == 0) {
                    return EMPTY_ITERATOR;
                }
                return new HashEnumIterator<Object>(entry -> entry.key);
            }
        };
    }

    @Override
    public synchronized V put(K key, V value) {
        if (key != null && value != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null && !entry.equalsKey(key, hash)) {
                entry = entry.next;
            }
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    index = (hash & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (index < this.firstSlot) {
                    this.firstSlot = index;
                }
                if (index > this.lastSlot) {
                    this.lastSlot = index;
                }
                entry = THashtable.newEntry(key, value, hash);
                entry.next = this.elementData[index];
                this.elementData[index] = entry;
                return null;
            }
            Object result = entry.value;
            entry.value = value;
            return (V)result;
        }
        throw new NullPointerException();
    }

    @Override
    public synchronized void putAll(TMap<? extends K, ? extends V> map) {
        TIterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rehash() {
        int length = (this.elementData.length << 1) + 1;
        if (length == 0) {
            length = 1;
        }
        int newFirst = length;
        int newLast = -1;
        Entry<K, V>[] newData = this.newElementArray(length);
        int i = this.lastSlot + 1;
        while (--i >= this.firstSlot) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                int index = (entry.getKeyHash() & Integer.MAX_VALUE) % length;
                if (index < newFirst) {
                    newFirst = index;
                }
                if (index > newLast) {
                    newLast = index;
                }
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.firstSlot = newFirst;
        this.lastSlot = newLast;
        this.elementData = newData;
        this.computeMaxSize();
    }

    @Override
    public synchronized V remove(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> last = null;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null && !entry.equalsKey(key, hash)) {
            last = entry;
            entry = entry.next;
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            Object result = entry.value;
            entry.value = null;
            return (V)result;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    @Override
    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.size() * 28);
        buffer.append('{');
        for (int i = this.lastSlot; i >= this.firstSlot; --i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    buffer.append(entry.key);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append('=');
                if (entry.value != this) {
                    buffer.append(entry.value);
                } else {
                    buffer.append("(this Map)");
                }
                buffer.append(", ");
                entry = entry.next;
            }
        }
        if (this.elementCount > 0) {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public TCollection<V> values() {
        return new TAbstractCollection<V>(){

            @Override
            public boolean contains(Object object) {
                return THashtable.this.contains(object);
            }

            @Override
            public int size() {
                return THashtable.this.elementCount;
            }

            @Override
            public void clear() {
                THashtable.this.clear();
            }

            @Override
            public TIterator<V> iterator() {
                return new HashIterator<Object>(entry -> entry.value);
            }
        };
    }

    private static class Entry<K, V>
    extends TMapEntry<K, V> {
        Entry<K, V> next;
        final int hashcode;

        Entry(K theKey, V theValue) {
            super(theKey, theValue);
            this.hashcode = theKey.hashCode();
        }

        @Override
        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        @Override
        public V setValue(V object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object result = this.value;
            this.value = object;
            return (V)result;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object aKey, int hash) {
            return this.hashcode == aKey.hashCode() && this.key.equals(aKey);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    class HashEnumIterator<E>
    extends HashIterator<E>
    implements TEnumeration<E> {
        private boolean isEnumeration;
        int start;
        Entry<K, V> entry;

        HashEnumIterator(TMapEntry.Type<E, K, V> value) {
            super(value);
        }

        HashEnumIterator(TMapEntry.Type<E, K, V> value, boolean isEnumeration) {
            super(value);
            this.isEnumeration = isEnumeration;
            this.start = THashtable.this.lastSlot + 1;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.isEnumeration) {
                if (this.entry != null) {
                    return true;
                }
                while (this.start > THashtable.this.firstSlot) {
                    if (THashtable.this.elementData[--this.start] == null) continue;
                    this.entry = THashtable.this.elementData[this.start];
                    return true;
                }
                return false;
            }
            return super.hasNext();
        }

        @Override
        public boolean hasNext() {
            if (this.isEnumeration) {
                return this.hasMoreElements();
            }
            return super.hasNext();
        }

        @Override
        public E next() {
            if (this.isEnumeration) {
                if (this.expectedModCount == THashtable.this.modCount) {
                    return this.nextElement();
                }
                throw new TConcurrentModificationException();
            }
            return super.next();
        }

        @Override
        public E nextElement() {
            if (this.isEnumeration) {
                if (this.hasMoreElements()) {
                    Object result = this.type.get(this.entry);
                    this.entry = this.entry.next;
                    return (E)result;
                }
                throw new TNoSuchElementException();
            }
            return super.next();
        }

        @Override
        public void remove() {
            if (this.isEnumeration) {
                throw new TUnsupportedOperationException();
            }
            super.remove();
        }
    }

    private class HashIterator<E>
    implements TIterator<E> {
        int position;
        int expectedModCount;
        final TMapEntry.Type<E, K, V> type;
        Entry<K, V> lastEntry;
        int lastPosition;
        boolean canRemove;

        HashIterator(TMapEntry.Type<E, K, V> value) {
            this.type = value;
            this.position = THashtable.this.lastSlot;
            this.expectedModCount = THashtable.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.lastEntry != null && this.lastEntry.next != null) {
                return true;
            }
            while (this.position >= THashtable.this.firstSlot) {
                if (THashtable.this.elementData[this.position] == null) {
                    --this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.expectedModCount == THashtable.this.modCount) {
                if (this.lastEntry != null) {
                    this.lastEntry = this.lastEntry.next;
                }
                if (this.lastEntry == null) {
                    while (this.position >= THashtable.this.firstSlot) {
                        this.lastEntry = THashtable.this.elementData[this.position];
                        if (this.lastEntry != null) break;
                        --this.position;
                    }
                    if (this.lastEntry != null) {
                        this.lastPosition = this.position--;
                    }
                }
                if (this.lastEntry != null) {
                    this.canRemove = true;
                    return this.type.get(this.lastEntry);
                }
                throw new TNoSuchElementException();
            }
            throw new TConcurrentModificationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.expectedModCount == THashtable.this.modCount) {
                if (this.canRemove) {
                    this.canRemove = false;
                    THashtable tHashtable = THashtable.this;
                    synchronized (tHashtable) {
                        boolean removed = false;
                        Entry entry = THashtable.this.elementData[this.lastPosition];
                        if (entry == this.lastEntry) {
                            THashtable.this.elementData[this.lastPosition] = entry.next;
                            removed = true;
                        } else {
                            while (entry != null && entry.next != this.lastEntry) {
                                entry = entry.next;
                            }
                            if (entry != null) {
                                entry.next = this.lastEntry.next;
                                removed = true;
                            }
                        }
                        if (removed) {
                            ++THashtable.this.modCount;
                            --THashtable.this.elementCount;
                            ++this.expectedModCount;
                            return;
                        }
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            throw new TConcurrentModificationException();
        }
    }
}

