/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.util.Arrays;
import java.util.Objects;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.util.TLocale;

public class TDateFormatSymbols
implements TSerializable,
TCloneable {
    private TLocale locale;
    private String localPatternChars;
    String[] ampms;
    String[] eras;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    String[][] zoneStrings;

    public TDateFormatSymbols() {
        this(TLocale.getDefault());
    }

    public TDateFormatSymbols(TLocale locale) {
        this.locale = locale;
    }

    public Object clone() {
        TDateFormatSymbols symbols = new TDateFormatSymbols(this.locale);
        if (this.ampms != null) {
            symbols.ampms = Arrays.copyOf(this.ampms, this.ampms.length);
        }
        if (this.eras != null) {
            symbols.eras = Arrays.copyOf(this.eras, this.eras.length);
        }
        if (this.months != null) {
            symbols.months = Arrays.copyOf(this.months, this.months.length);
        }
        if (this.shortMonths != null) {
            symbols.shortMonths = Arrays.copyOf(this.shortMonths, this.shortMonths.length);
        }
        if (this.shortWeekdays != null) {
            symbols.shortWeekdays = Arrays.copyOf((String[])this.shortWeekdays.clone(), this.shortWeekdays.length);
        }
        if (this.weekdays != null) {
            symbols.weekdays = Arrays.copyOf(this.weekdays, this.weekdays.length);
        }
        if (this.zoneStrings != null) {
            symbols.zoneStrings = new String[this.zoneStrings.length][];
            for (int i = 0; i < this.zoneStrings.length; ++i) {
                symbols.zoneStrings[i] = Arrays.copyOf(this.zoneStrings[i], this.zoneStrings[i].length);
            }
        }
        return symbols;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TDateFormatSymbols)) {
            return false;
        }
        TDateFormatSymbols obj = (TDateFormatSymbols)object;
        if (!this.locale.equals(obj.locale)) {
            return false;
        }
        if (!Objects.equals(this.localPatternChars, obj.localPatternChars)) {
            return false;
        }
        if (!Arrays.equals(this.ampms, obj.ampms)) {
            return false;
        }
        if (!Arrays.equals(this.eras, obj.eras)) {
            return false;
        }
        if (!Arrays.equals(this.months, obj.months)) {
            return false;
        }
        if (!Arrays.equals(this.shortMonths, obj.shortMonths)) {
            return false;
        }
        if (!Arrays.equals(this.shortWeekdays, obj.shortWeekdays)) {
            return false;
        }
        if (!Arrays.equals(this.weekdays, obj.weekdays)) {
            return false;
        }
        return Arrays.equals((Object[])this.zoneStrings, (Object[])obj.zoneStrings);
    }

    public String[] getAmPmStrings() {
        if (this.ampms == null) {
            this.ampms = CLDRHelper.resolveAmPm(this.locale.getLanguage(), this.locale.getCountry());
        }
        return (String[])this.ampms.clone();
    }

    public String[] getEras() {
        if (this.eras == null) {
            this.eras = CLDRHelper.resolveEras(this.locale.getLanguage(), this.locale.getCountry());
        }
        return (String[])this.eras.clone();
    }

    public String getLocalPatternChars() {
        if (this.localPatternChars == null) {
            this.localPatternChars = "";
        }
        return this.localPatternChars;
    }

    public String[] getMonths() {
        if (this.months == null) {
            this.months = CLDRHelper.resolveMonths(this.locale.getLanguage(), this.locale.getCountry());
        }
        return (String[])this.months.clone();
    }

    public String[] getShortMonths() {
        if (this.shortMonths == null) {
            this.shortMonths = CLDRHelper.resolveShortMonths(this.locale.getLanguage(), this.locale.getCountry());
        }
        return (String[])this.shortMonths.clone();
    }

    public String[] getShortWeekdays() {
        if (this.shortWeekdays == null) {
            this.shortWeekdays = new String[8];
            String[] cldrWeekdays = CLDRHelper.resolveShortWeekdays(this.locale.getLanguage(), this.locale.getCountry());
            for (int i = 0; i < 7; ++i) {
                this.shortWeekdays[i + 1] = cldrWeekdays[i];
            }
        }
        return (String[])this.shortWeekdays.clone();
    }

    public String[] getWeekdays() {
        if (this.weekdays == null) {
            this.weekdays = new String[8];
            String[] cldrWeekdays = CLDRHelper.resolveWeekdays(this.locale.getLanguage(), this.locale.getCountry());
            for (int i = 0; i < 7; ++i) {
                this.weekdays[i + 1] = cldrWeekdays[i];
            }
        }
        return (String[])this.weekdays.clone();
    }

    public String[][] getZoneStrings() {
        if (this.zoneStrings == null) {
            return new String[0][];
        }
        String[][] clone = new String[this.zoneStrings.length][];
        int i = this.zoneStrings.length;
        while (--i >= 0) {
            clone[i] = (String[])this.zoneStrings[i].clone();
        }
        return clone;
    }

    public int hashCode() {
        int hashCode = this.localPatternChars.hashCode();
        for (String string : this.ampms) {
            hashCode += string.hashCode();
        }
        for (String string : this.eras) {
            hashCode += string.hashCode();
        }
        for (String string : this.months) {
            hashCode += string.hashCode();
        }
        for (String string : this.shortMonths) {
            hashCode += string.hashCode();
        }
        for (String string : this.shortWeekdays) {
            hashCode += string.hashCode();
        }
        for (String string : this.weekdays) {
            hashCode += string.hashCode();
        }
        for (String string : this.zoneStrings) {
            for (int j = 0; j < ((String)string).length; ++j) {
                if (string[j] == null) continue;
                hashCode += string[j].hashCode();
            }
        }
        return hashCode;
    }

    public void setAmPmStrings(String[] data) {
        this.ampms = (String[])data.clone();
    }

    public void setEras(String[] data) {
        this.eras = (String[])data.clone();
    }

    public void setLocalPatternChars(String data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.localPatternChars = data;
    }

    public void setMonths(String[] data) {
        this.months = (String[])data.clone();
    }

    public void setShortMonths(String[] data) {
        this.shortMonths = (String[])data.clone();
    }

    public void setShortWeekdays(String[] data) {
        this.shortWeekdays = (String[])data.clone();
    }

    public void setWeekdays(String[] data) {
        this.weekdays = (String[])data.clone();
    }

    public void setZoneStrings(String[][] data) {
        this.zoneStrings = (String[][])data.clone();
    }

    public static TDateFormatSymbols getInstance(TLocale locale) {
        return new TDateFormatSymbols(locale);
    }
}

