/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.List;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.DynamicCallSite;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.emit.PhiEmitter;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;

public class SwitchBootstrapSubstitutor
implements BootstrapMethodSubstitutor {
    public ValueEmitter substitute(DynamicCallSite callSite, ProgramEmitter pe) {
        ValueType.Object enumType;
        boolean enumSwitch = callSite.getBootstrapMethod().getName().equals("enumSwitch");
        List labels = callSite.getBootstrapArguments();
        ValueEmitter target = (ValueEmitter)callSite.getArguments().get(0);
        ValueEmitter restartIdx = (ValueEmitter)callSite.getArguments().get(1);
        BasicBlock joint = pe.prepareBlock();
        PhiEmitter result = pe.phi((ValueType)ValueType.INTEGER, joint);
        pe.when(() -> target.isNull()).thenDo(() -> {
            pe.constant(-1).propagateTo(result);
            pe.jump(joint);
        });
        SwitchInstruction switchInsn = new SwitchInstruction();
        switchInsn.setCondition(restartIdx.getVariable());
        pe.addInstruction((Instruction)switchInsn);
        BasicBlock block = pe.prepareBlock();
        pe.enter(block);
        ValueType.Object object = enumType = enumSwitch ? (ValueType.Object)callSite.getCalledMethod().parameterType(0) : null;
        if (enumType != null) {
            pe.initClass(enumType.getClassName());
        }
        for (int i = 0; i < labels.size(); ++i) {
            SwitchTableEntry entry = new SwitchTableEntry();
            entry.setCondition(i);
            entry.setTarget(block);
            switchInsn.getEntries().add(entry);
            RuntimeConstant label = (RuntimeConstant)labels.get(i);
            this.emitFragment(target, i, label, pe, result, joint, enumType);
            block = pe.prepareBlock();
            pe.jump(block);
            pe.enter(block);
        }
        switchInsn.setDefaultTarget(block);
        pe.constant(callSite.getBootstrapArguments().size()).propagateTo(result);
        pe.jump(joint);
        pe.enter(joint);
        return result.getValue();
    }

    private void emitFragment(ValueEmitter target, int idx, RuntimeConstant label, ProgramEmitter pe, PhiEmitter result, BasicBlock exit, ValueType.Object enumType) {
        switch (label.getKind()) {
            case 5: {
                ValueType type = label.getValueType();
                pe.when(() -> target.instanceOf(type).isTrue()).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                break;
            }
            case 0: {
                int val = label.getInt();
                pe.when(() -> target.instanceOf((ValueType)ValueType.object((String)"java.lang.Number")).isTrue().and(() -> target.cast(Number.class).invokeVirtual("intValue", Integer.TYPE, new ValueEmitter[0]).isSame(pe.constant(val)))).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                pe.when(() -> target.instanceOf((ValueType)ValueType.object((String)"java.lang.Character")).isTrue().and(() -> target.cast(Character.class).invokeSpecial("charValue", Character.TYPE, new ValueEmitter[0]).isSame(pe.constant(val)))).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                break;
            }
            case 4: {
                String str = label.getString();
                pe.when(enumType != null ? () -> pe.getField(enumType.getClassName(), str, (ValueType)enumType).isSame(target) : () -> pe.constant(str).isEqualTo(target)).thenDo(() -> {
                    pe.constant(idx).propagateTo(result);
                    pe.jump(exit);
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported constant type: " + label.getKind());
            }
        }
    }
}

