/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import java.util.MissingResourceException;
import org.teavm.classlib.java.util.regex.TAbstractCharClass;
import org.teavm.classlib.java.util.regex.TCharClass;
import org.teavm.classlib.java.util.regex.TIntArrHash;
import org.teavm.classlib.java.util.regex.TIntHash;
import org.teavm.classlib.java.util.regex.TPattern;
import org.teavm.classlib.java.util.regex.TPatternSyntaxException;
import org.teavm.classlib.java.util.regex.TQuantifier;
import org.teavm.classlib.java.util.regex.TSpecialToken;

class TLexer {
    public static final int CHAR_DOLLAR = -536870876;
    public static final int CHAR_RIGHT_PARENTHESIS = -536870871;
    public static final int CHAR_LEFT_SQUARE_BRACKET = -536870821;
    public static final int CHAR_RIGHT_SQUARE_BRACKET = -536870819;
    public static final int CHAR_CARET = -536870818;
    public static final int CHAR_VERTICAL_BAR = -536870788;
    public static final int CHAR_AMPERSAND = -536870874;
    public static final int CHAR_HYPHEN = -536870867;
    public static final int CHAR_DOT = -536870866;
    public static final int QMOD_GREEDY = -536870912;
    public static final int QMOD_RELUCTANT = -1073741824;
    public static final int QMOD_POSSESSIVE = Integer.MIN_VALUE;
    public static final int QUANT_STAR = -536870870;
    public static final int QUANT_STAR_P = -2147483606;
    public static final int QUANT_STAR_R = -1073741782;
    public static final int QUANT_PLUS = -536870869;
    public static final int QUANT_PLUS_P = -2147483605;
    public static final int QUANT_PLUS_R = -1073741781;
    public static final int QUANT_ALT = -536870849;
    public static final int QUANT_ALT_P = -2147483585;
    public static final int QUANT_ALT_R = -1073741761;
    public static final int QUANT_COMP = -536870789;
    public static final int QUANT_COMP_P = -2147483525;
    public static final int QUANT_COMP_R = -1073741701;
    public static final int CHAR_LEFT_PARENTHESIS = -2147483608;
    public static final int CHAR_NONCAP_GROUP = -1073741784;
    public static final int CHAR_POS_LOOKAHEAD = -536870872;
    public static final int CHAR_NEG_LOOKAHEAD = -268435416;
    public static final int CHAR_POS_LOOKBEHIND = -134217688;
    public static final int CHAR_NEG_LOOKBEHIND = -67108824;
    public static final int CHAR_ATOMIC_GROUP = -33554392;
    public static final int CHAR_FLAGS = -16777176;
    public static final int CHAR_START_OF_INPUT = -2147483583;
    public static final int CHAR_WORD_BOUND = -2147483550;
    public static final int CHAR_NONWORD_BOUND = -2147483582;
    public static final int CHAR_PREVIOUS_MATCH = -2147483577;
    public static final int CHAR_END_OF_INPUT = -2147483526;
    public static final int CHAR_END_OF_LINE = -2147483558;
    public static final int MODE_PATTERN = 1;
    public static final int MODE_RANGE = 2;
    public static final int MODE_ESCAPE = 4;
    static final int MAX_DECOMPOSITION_LENGTH = 4;
    static final int MAX_HANGUL_DECOMPOSITION_LENGTH = 3;
    static final int SBase = 44032;
    static final int LBase = 4352;
    static final int VBase = 4449;
    static final int TBase = 4519;
    static final int SCount = 11172;
    static final int LCount = 19;
    static final int VCount = 21;
    static final int TCount = 28;
    static final int NCount = 588;
    private static TIntArrHash decompTable = null;
    private static TIntHash singleDecompTable = null;
    private static int singleDecompTableSize;
    private char[] pattern = null;
    private int flags = 0;
    private int mode = 1;
    private int saved_mode = 0;
    private int lookBack;
    private int ch;
    private int lookAhead;
    private int patternFullLength = 0;
    private TSpecialToken curST = null;
    private TSpecialToken lookAheadST = null;
    private int index = 0;
    private int prevNW = 0;
    private int curToc = 0;
    private int lookAheadToc = 0;
    private String orig = null;

    public TLexer(String pattern, int flags) {
        this.orig = pattern;
        if ((flags & 0x10) > 0) {
            pattern = TPattern.quote(pattern);
        } else if ((flags & 0x80) > 0) {
            pattern = TLexer.normalize(pattern);
        }
        this.pattern = new char[pattern.length() + 2];
        System.arraycopy(pattern.toCharArray(), 0, this.pattern, 0, pattern.length());
        this.pattern[this.pattern.length - 1] = '\u0000';
        this.pattern[this.pattern.length - 2] = '\u0000';
        this.patternFullLength = this.pattern.length;
        this.flags = flags;
        this.movePointer();
        this.movePointer();
    }

    public int peek() {
        return this.ch;
    }

    public void setMode(int mode) {
        if (mode > 0 && mode < 3) {
            this.mode = mode;
        }
        if (mode == 1) {
            this.reread();
        }
    }

    public void restoreFlags(int flags) {
        this.flags = flags;
        this.lookAhead = this.ch;
        this.lookAheadST = this.curST;
        this.index = this.curToc + 1;
        this.lookAheadToc = this.curToc;
        this.movePointer();
    }

    public TSpecialToken peekSpecial() {
        return this.curST;
    }

    public boolean isSpecial() {
        return this.curST != null;
    }

    public boolean isQuantifier() {
        return this.isSpecial() && this.curST.getType() == 2;
    }

    public boolean isNextSpecial() {
        return this.lookAheadST != null;
    }

    public int next() {
        this.movePointer();
        return this.lookBack;
    }

    public TSpecialToken nextSpecial() {
        TSpecialToken res = this.curST;
        this.movePointer();
        return res;
    }

    public int lookAhead() {
        return this.lookAhead;
    }

    public int back() {
        return this.lookBack;
    }

    static String normalize(String input) {
        return input;
    }

    private void reread() {
        this.lookAhead = this.ch;
        this.lookAheadST = this.curST;
        this.index = this.lookAheadToc;
        this.lookAheadToc = this.curToc;
        this.movePointer();
    }

    private void movePointer() {
        boolean reread;
        this.lookBack = this.ch;
        this.ch = this.lookAhead;
        this.curST = this.lookAheadST;
        this.curToc = this.lookAheadToc;
        this.lookAheadToc = this.index;
        block62: do {
            block71: {
                block72: {
                    reread = false;
                    this.lookAhead = this.index < this.pattern.length ? this.nextCodePoint() : 0;
                    this.lookAheadST = null;
                    if (this.mode != 4) break block71;
                    if (this.lookAhead != 92) break block72;
                    this.lookAhead = this.index < this.pattern.length ? this.pattern[this.nextIndex()] : 0;
                    switch (this.lookAhead) {
                        case 69: {
                            this.mode = this.saved_mode;
                            this.lookAhead = this.index <= this.pattern.length - 2 ? this.nextCodePoint() : 0;
                            break block71;
                        }
                        default: {
                            this.lookAhead = 92;
                            this.index = this.prevNW;
                            return;
                        }
                    }
                }
                return;
            }
            if (this.lookAhead == 92) {
                this.lookAhead = this.index < this.pattern.length - 2 ? this.nextCodePoint() : -1;
                switch (this.lookAhead) {
                    case -1: {
                        throw new TPatternSyntaxException("", this.toString(), this.index);
                    }
                    case 80: 
                    case 112: {
                        String cs = this.parseCharClassName();
                        boolean negative = false;
                        if (this.lookAhead == 80) {
                            negative = true;
                        }
                        try {
                            this.lookAheadST = TAbstractCharClass.getPredefinedClass(cs, negative);
                        }
                        catch (MissingResourceException mre) {
                            throw new TPatternSyntaxException("", this.toString(), this.index);
                        }
                        this.lookAhead = 0;
                        break;
                    }
                    case 68: 
                    case 83: 
                    case 87: 
                    case 100: 
                    case 115: 
                    case 119: {
                        this.lookAheadST = TCharClass.getPredefinedClass(new String(this.pattern, this.prevNW, 1), false);
                        this.lookAhead = 0;
                        break;
                    }
                    case 81: {
                        this.saved_mode = this.mode;
                        this.mode = 4;
                        reread = true;
                        break;
                    }
                    case 116: {
                        this.lookAhead = 9;
                        break;
                    }
                    case 110: {
                        this.lookAhead = 10;
                        break;
                    }
                    case 114: {
                        this.lookAhead = 13;
                        break;
                    }
                    case 102: {
                        this.lookAhead = 12;
                        break;
                    }
                    case 97: {
                        this.lookAhead = 7;
                        break;
                    }
                    case 101: {
                        this.lookAhead = 27;
                        break;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (this.mode != 1) continue block62;
                        this.lookAhead = Integer.MIN_VALUE | this.lookAhead;
                        break;
                    }
                    case 48: {
                        this.lookAhead = this.readOctals();
                        break;
                    }
                    case 120: {
                        this.lookAhead = this.readHex(2);
                        break;
                    }
                    case 117: {
                        this.lookAhead = this.readHex(4);
                        break;
                    }
                    case 98: {
                        this.lookAhead = -2147483550;
                        break;
                    }
                    case 66: {
                        this.lookAhead = -2147483582;
                        break;
                    }
                    case 65: {
                        this.lookAhead = -2147483583;
                        break;
                    }
                    case 71: {
                        this.lookAhead = -2147483577;
                        break;
                    }
                    case 90: {
                        this.lookAhead = -2147483558;
                        break;
                    }
                    case 122: {
                        this.lookAhead = -2147483526;
                        break;
                    }
                    case 99: {
                        if (this.index < this.pattern.length - 2) {
                            this.lookAhead = this.pattern[this.nextIndex()] & 0x1F;
                            break;
                        }
                        throw new TPatternSyntaxException("", this.toString(), this.index);
                    }
                    case 67: 
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 82: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 111: 
                    case 113: 
                    case 121: {
                        throw new TPatternSyntaxException("", this.toString(), this.index);
                    }
                }
                continue;
            }
            if (this.mode == 1) {
                block28 : switch (this.lookAhead) {
                    case 42: 
                    case 43: 
                    case 63: {
                        int mod = this.index < this.pattern.length ? this.pattern[this.index] : 42;
                        switch (mod) {
                            case 43: {
                                this.lookAhead |= Integer.MIN_VALUE;
                                this.nextIndex();
                                break block28;
                            }
                            case 63: {
                                this.lookAhead |= 0xC0000000;
                                this.nextIndex();
                                break block28;
                            }
                        }
                        this.lookAhead |= 0xE0000000;
                        break;
                    }
                    case 123: {
                        this.lookAheadST = this.processQuantifier(this.lookAhead);
                        break;
                    }
                    case 36: {
                        this.lookAhead = -536870876;
                        break;
                    }
                    case 40: {
                        if (this.pattern[this.index] == '?') {
                            this.nextIndex();
                            char nonCap = this.pattern[this.index];
                            boolean behind = false;
                            do {
                                if (!behind) {
                                    switch (nonCap) {
                                        case '!': {
                                            this.lookAhead = -268435416;
                                            this.nextIndex();
                                            break;
                                        }
                                        case '=': {
                                            this.lookAhead = -536870872;
                                            this.nextIndex();
                                            break;
                                        }
                                        case '>': {
                                            this.lookAhead = -33554392;
                                            this.nextIndex();
                                            break;
                                        }
                                        case '<': {
                                            this.nextIndex();
                                            nonCap = this.pattern[this.index];
                                            behind = true;
                                            break;
                                        }
                                        default: {
                                            this.lookAhead = this.readFlags();
                                            if (this.lookAhead >= 256) {
                                                this.lookAhead &= 0xFF;
                                                this.flags = this.lookAhead;
                                                this.lookAhead <<= 16;
                                                this.lookAhead = 0xFF000028 | this.lookAhead;
                                                break;
                                            }
                                            this.flags = this.lookAhead;
                                            this.lookAhead <<= 16;
                                            this.lookAhead = 0xC0000028 | this.lookAhead;
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                behind = false;
                                switch (nonCap) {
                                    case '!': {
                                        this.lookAhead = -67108824;
                                        this.nextIndex();
                                        break;
                                    }
                                    case '=': {
                                        this.lookAhead = -134217688;
                                        this.nextIndex();
                                        break;
                                    }
                                    default: {
                                        throw new TPatternSyntaxException("", this.toString(), this.index);
                                    }
                                }
                            } while (behind);
                            break;
                        }
                        this.lookAhead = -2147483608;
                        break;
                    }
                    case 41: {
                        this.lookAhead = -536870871;
                        break;
                    }
                    case 91: {
                        this.lookAhead = -536870821;
                        this.setMode(2);
                        break;
                    }
                    case 93: {
                        if (this.mode != 2) continue block62;
                        this.lookAhead = -536870819;
                        break;
                    }
                    case 94: {
                        this.lookAhead = -536870818;
                        break;
                    }
                    case 124: {
                        this.lookAhead = -536870788;
                        break;
                    }
                    case 46: {
                        this.lookAhead = -536870866;
                        break;
                    }
                }
                continue;
            }
            if (this.mode != 2) continue;
            switch (this.lookAhead) {
                case 91: {
                    this.lookAhead = -536870821;
                    break;
                }
                case 93: {
                    this.lookAhead = -536870819;
                    break;
                }
                case 94: {
                    this.lookAhead = -536870818;
                    break;
                }
                case 38: {
                    this.lookAhead = -536870874;
                    break;
                }
                case 45: {
                    this.lookAhead = -536870867;
                    break;
                }
            }
        } while (reread);
    }

    private String parseCharClassName() {
        StringBuilder sb = new StringBuilder(10);
        if (this.index < this.pattern.length - 2) {
            if (this.pattern[this.index] != '{') {
                return "Is" + new String(this.pattern, this.nextIndex(), 1);
            }
            this.nextIndex();
            char ch = '\u0000';
            while (this.index < this.pattern.length - 2 && (ch = this.pattern[this.nextIndex()]) != '}') {
                sb.append(ch);
            }
            if (ch != '}') {
                throw new TPatternSyntaxException("", this.toString(), this.index);
            }
        }
        if (sb.length() == 0) {
            throw new TPatternSyntaxException("", this.toString(), this.index);
        }
        String res = sb.toString();
        if (res.length() == 1) {
            return "Is" + res;
        }
        return res.length() > 3 && (res.startsWith("Is") || res.startsWith("In")) ? res.substring(2) : res;
    }

    /*
     * Unable to fully structure code
     */
    private TQuantifier processQuantifier(int ch) {
        sb = new StringBuilder(4);
        min = -1;
        max = 0x7FFFFFFF;
        while (this.index < this.pattern.length && (ch = this.pattern[this.nextIndex()]) != 125) {
            if (ch == 44 && min < 0) {
                try {
                    min = Integer.parseInt(sb.toString(), 10);
                    sb.delete(0, sb.length());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new TPatternSyntaxException("", this.toString(), this.index);
                }
            }
            sb.append((char)ch);
        }
        if (ch != 125) {
            throw new TPatternSyntaxException("", this.toString(), this.index);
        }
        if (sb.length() > 0) {
            try {
                max = Integer.parseInt(sb.toString(), 10);
                if (min >= 0) ** GOTO lbl28
                min = max;
            }
            catch (NumberFormatException nfe) {
                throw new TPatternSyntaxException("", this.toString(), this.index);
            }
        } else if (min < 0) {
            throw new TPatternSyntaxException("", this.toString(), this.index);
        }
lbl28:
        // 4 sources

        if ((min | max | max - min) < 0) {
            throw new TPatternSyntaxException("", this.toString(), this.index);
        }
        mod = this.index < this.pattern.length ? this.pattern[this.index] : 42;
        switch (mod) {
            case 43: {
                this.lookAhead = -2147483525;
                this.nextIndex();
                break;
            }
            case 63: {
                this.lookAhead = -1073741701;
                this.nextIndex();
                break;
            }
            default: {
                this.lookAhead = -536870789;
            }
        }
        return new TQuantifier(min, max);
    }

    public String toString() {
        return this.orig;
    }

    public boolean isEmpty() {
        return this.ch == 0 && this.lookAhead == 0 && this.index == this.patternFullLength && !this.isSpecial();
    }

    public static boolean isLetter(int ch) {
        return ch >= 0;
    }

    public boolean isLetter() {
        return !this.isEmpty() && !this.isSpecial() && TLexer.isLetter(this.ch);
    }

    public boolean isHighSurrogate() {
        return this.ch <= 56319 && this.ch >= 55296;
    }

    public boolean isLowSurrogate() {
        return this.ch <= 57343 && this.ch >= 56320;
    }

    public static boolean isHighSurrogate(int ch) {
        return ch <= 56319 && ch >= 55296;
    }

    public static boolean isLowSurrogate(int ch) {
        return ch <= 57343 && ch >= 56320;
    }

    private int readHex(int max) {
        int i;
        StringBuilder st = new StringBuilder(max);
        int length = this.pattern.length - 2;
        for (i = 0; i < max && this.index < length; ++i) {
            st.append(this.pattern[this.nextIndex()]);
        }
        if (i == max) {
            try {
                return Integer.parseInt(st.toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new TPatternSyntaxException("", this.toString(), this.index);
    }

    private int readOctals() {
        int max = 3;
        int i = 1;
        int length = this.pattern.length - 2;
        int first = Character.digit(this.pattern[this.index], 8);
        switch (first) {
            case -1: {
                throw new TPatternSyntaxException("", this.toString(), this.index);
            }
        }
        if (first > 3) {
            --max;
        }
        this.nextIndex();
        int res = first;
        while (i < max && this.index < length && (first = Character.digit(this.pattern[this.index], 8)) >= 0) {
            res = res * 8 + first;
            this.nextIndex();
            ++i;
        }
        return res;
    }

    private int readFlags() {
        boolean pos = true;
        int res = this.flags;
        while (this.index < this.pattern.length) {
            char ch = this.pattern[this.index];
            switch (ch) {
                case '-': {
                    if (!pos) {
                        throw new TPatternSyntaxException("", this.toString(), this.index);
                    }
                    pos = false;
                    break;
                }
                case 'i': {
                    res = pos ? res | 2 : (res ^ 2) & res;
                    break;
                }
                case 'd': {
                    res = pos ? res | 1 : (res ^ 1) & res;
                    break;
                }
                case 'm': {
                    res = pos ? res | 8 : (res ^ 8) & res;
                    break;
                }
                case 's': {
                    res = pos ? res | 0x20 : (res ^ 0x20) & res;
                    break;
                }
                case 'u': {
                    res = pos ? res | 0x40 : (res ^ 0x40) & res;
                    break;
                }
                case 'x': {
                    res = pos ? res | 4 : (res ^ 4) & res;
                    break;
                }
                case ':': {
                    this.nextIndex();
                    return res;
                }
                case ')': {
                    this.nextIndex();
                    return res | 0x100;
                }
            }
            this.nextIndex();
        }
        throw new TPatternSyntaxException("", this.toString(), this.index);
    }

    private int nextIndex() {
        block0: {
            this.prevNW = this.index++;
            if ((this.flags & 4) == 0) break block0;
            this.skipComments();
        }
        return this.prevNW;
    }

    /*
     * Unable to fully structure code
     */
    private int skipComments() {
        length = this.pattern.length - 2;
        ++this.index;
        block0: while (true) {
            if (this.index < length && Character.isWhitespace(this.pattern[this.index])) {
                ++this.index;
                continue;
            }
            if (this.index >= length || this.pattern[this.index] != '#') break;
            ++this.index;
            while (true) {
                if (this.index < length && !this.isLineSeparator(this.pattern[this.index])) ** break;
                continue block0;
                ++this.index;
            }
            break;
        }
        return this.index;
    }

    private boolean isLineSeparator(int ch) {
        return ch == 10 || ch == 13 || ch == 133 || (ch | 1) == 8233;
    }

    static int[] getDecomposition(int ch) {
        return decompTable.get(ch);
    }

    static int[] getHangulDecomposition(int ch) {
        int[] decomp;
        int SIndex = ch - 44032;
        if (SIndex < 0 || SIndex >= 11172) {
            return null;
        }
        int L = 4352 + SIndex / 588;
        int V = 4449 + SIndex % 588 / 28;
        int T = SIndex % 28;
        if (T == 0) {
            decomp = new int[]{L, V};
        } else {
            T = 4519 + T;
            decomp = new int[]{L, V, T};
        }
        return decomp;
    }

    static boolean hasSingleCodepointDecomposition(int ch) {
        int hasSingleDecomp = singleDecompTable.get(ch);
        return hasSingleDecomp != singleDecompTableSize;
    }

    static boolean hasDecompositionNonNullCanClass(int ch) {
        return ch == 832 | ch == 833 | ch == 835 | ch == 836;
    }

    private int nextCodePoint() {
        char low;
        int lowExpectedIndex;
        char high = this.pattern[this.nextIndex()];
        if (Character.isHighSurrogate(high) && (lowExpectedIndex = this.prevNW + 1) < this.pattern.length && Character.isLowSurrogate(low = this.pattern[lowExpectedIndex])) {
            this.nextIndex();
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    public int getIndex() {
        return this.curToc;
    }
}

