/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TRunnable;
import org.teavm.classlib.java.lang.TStackTraceElement;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.javascript.spi.Async;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformRunnable;
import org.teavm.platform.async.AsyncCallback;

public class TThread
extends TObject
implements TRunnable {
    private static TThread mainThread;
    private static TThread currentThread;
    private static long nextId;
    private static int activeCount;
    private long id;
    private int priority;
    private long timeSliceStart;
    private int yieldCount;
    private final Object finishedLock = new Object();
    private boolean interruptedFlag;
    private TThreadInterruptHandler interruptHandler;
    private TString name;
    TRunnable target;

    public TThread() {
        this(null, null);
    }

    public TThread(TString name) {
        this(null, name);
    }

    public TThread(TRunnable target) {
        this(target, null);
    }

    public TThread(TRunnable target, TString name) {
        this.name = name;
        this.target = target;
        this.id = nextId++;
    }

    public void start() {
        Platform.startThread((PlatformRunnable)new PlatformRunnable(){

            public void run() {
                try {
                    activeCount++;
                    TThread.setCurrentThread(TThread.this);
                    TThread.this.run();
                }
                finally {
                    activeCount--;
                    TThread.setCurrentThread(mainThread);
                }
            }
        });
    }

    static void setCurrentThread(TThread thread) {
        if (currentThread != thread) {
            currentThread = thread;
        }
        TThread.currentThread.timeSliceStart = System.currentTimeMillis();
    }

    static TThread getMainThread() {
        return mainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
        Object object = this.finishedLock;
        synchronized (object) {
            this.finishedLock.notifyAll();
        }
    }

    public static TThread currentThread() {
        return currentThread;
    }

    public TString getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        if (TThread.currentThread() == this) {
            return;
        }
        Object object = this.finishedLock;
        synchronized (object) {
            this.finishedLock.wait(millis, nanos);
        }
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void yield() {
        TThread currentThread = TThread.currentThread();
        if (++currentThread.yieldCount < 30) {
            return;
        }
        TThread.currentThread().yieldCount = 0;
        if (currentThread.timeSliceStart + 100L < System.currentTimeMillis()) {
            TThread.switchContext(currentThread);
        }
    }

    @Async
    static native void switchContext(TThread var0);

    private static void switchContext(final TThread thread, final AsyncCallback<Void> callback) {
        Platform.postpone((PlatformRunnable)new PlatformRunnable(){

            public void run() {
                TThread.setCurrentThread(thread);
                callback.complete(null);
            }
        });
    }

    public void interrupt() {
        this.interruptedFlag = true;
        if (this.interruptHandler != null) {
            this.interruptHandler.interrupted();
            this.interruptHandler = null;
        }
    }

    public static boolean interrupted() {
        TThread thread = TThread.currentThread();
        boolean result = thread.interruptedFlag;
        thread.interruptedFlag = false;
        return result;
    }

    public boolean isInterrupted() {
        return this.interruptedFlag;
    }

    public static int activeCount() {
        return activeCount;
    }

    public long getId() {
        return this.id;
    }

    public static boolean holdsLock(TObject obj) {
        return TObject.holdsLock(obj);
    }

    @Async
    public static native void sleep(long var0) throws TInterruptedException;

    private static void sleep(long millis, AsyncCallback<Void> callback) {
        TThread current = TThread.currentThread();
        int intMillis = millis < Integer.MAX_VALUE ? (int)millis : Integer.MAX_VALUE;
        SleepHandler handler = new SleepHandler(current, callback);
        handler.scheduleId = Platform.schedule((PlatformRunnable)handler, (int)intMillis);
        current.interruptHandler = handler;
    }

    public final void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    public final int getPriority() {
        return this.priority;
    }

    public TStackTraceElement[] getStackTrace() {
        return new TStackTraceElement[0];
    }

    static {
        currentThread = mainThread = new TThread(TString.wrap("main"));
        nextId = 1L;
        activeCount = 1;
    }

    private static class SleepHandler
    implements PlatformRunnable,
    TThreadInterruptHandler {
        private TThread thread;
        private AsyncCallback<Void> callback;
        private boolean isInterrupted;
        int scheduleId;

        public SleepHandler(TThread thread, AsyncCallback<Void> callback) {
            this.thread = thread;
            this.callback = callback;
        }

        @Override
        public void interrupted() {
            this.thread.interruptedFlag = false;
            this.isInterrupted = true;
            Platform.killSchedule((int)this.scheduleId);
            Platform.postpone((PlatformRunnable)new PlatformRunnable(){

                public void run() {
                    callback.error((Throwable)new TInterruptedException());
                }
            });
        }

        public void run() {
            if (!this.isInterrupted) {
                this.thread.interruptHandler = null;
                TThread.setCurrentThread(this.thread);
                this.callback.complete(null);
            }
        }
    }
}

