/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.List;
import java.util.Properties;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldHolder;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class ScalaHacks
implements ClassHolderTransformer {
    private static final String ATTR_NAME_CLASS = "java.util.jar.Attributes$Name";

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        switch (cls.getName()) {
            case "scala.util.PropertiesTrait$class": {
                this.transformPropertiesTrait(cls, innerSource);
                break;
            }
            case "scala.util.Properties$": {
                this.transformProperties(cls);
            }
        }
    }

    private void transformPropertiesTrait(ClassHolder cls, ClassReaderSource innerSource) {
        for (MethodHolder method : cls.getMethods()) {
            if (!method.getName().equals("scalaProps")) continue;
            ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassReaderSource)innerSource);
            pe.construct(Properties.class, new ValueEmitter[0]).returnValue();
        }
    }

    private void transformProperties(ClassHolder cls) {
        for (FieldHolder fieldHolder : cls.getFields().toArray(new FieldHolder[0])) {
            if (!fieldHolder.getName().equals("ScalaCompilerVersion")) continue;
            cls.removeField(fieldHolder);
        }
        for (FieldHolder fieldHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            if (fieldHolder.getName().equals("ScalaCompilerVersion")) {
                cls.removeMethod((MethodHolder)fieldHolder);
                continue;
            }
            if (!fieldHolder.getName().equals("<init>")) continue;
            Program program = fieldHolder.getProgram();
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                List instructions = block.getInstructions();
                for (int j = 0; j < instructions.size(); ++j) {
                    ConstructInstruction cons;
                    Instruction insn = (Instruction)instructions.get(j);
                    if (insn instanceof InvokeInstruction) {
                        if (!((InvokeInstruction)insn).getMethod().getClassName().equals(ATTR_NAME_CLASS)) continue;
                        instructions.remove(j--);
                        continue;
                    }
                    if (insn instanceof PutFieldInstruction) {
                        if (!((PutFieldInstruction)insn).getField().getFieldName().equals("ScalaCompilerVersion")) continue;
                        instructions.remove(j--);
                        continue;
                    }
                    if (!(insn instanceof ConstructInstruction) || !(cons = (ConstructInstruction)insn).getType().equals(ATTR_NAME_CLASS)) continue;
                    cons.setType("java.lang.Object");
                }
            }
        }
    }
}

