/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.FloatNativeGenerator;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.javascript.spi.GeneratedBy;

public class TFloat
extends TNumber
implements TComparable<TFloat> {
    public static final float POSITIVE_INFINITY = Float.POSITIVE_INFINITY;
    public static final float NEGATIVE_INFINITY = Float.NEGATIVE_INFINITY;
    public static final float NaN = TFloat.getNaN();
    public static final float MAX_VALUE = Float.MAX_VALUE;
    public static final float MIN_VALUE = Float.MIN_NORMAL;
    public static final float MIN_NORMAL = Float.MIN_VALUE;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final TClass<TFloat> TYPE = TClass.floatClass();
    private float value;

    public TFloat(float value) {
        this.value = value;
    }

    public TFloat(double value) {
        this((float)value);
    }

    public TFloat(TString value) throws TNumberFormatException {
        this(TFloat.parseFloat(value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static TFloat valueOf(float d) {
        return new TFloat(d);
    }

    public static String toString(float d) {
        return new TStringBuilder().append(d).toString();
    }

    @Override
    public String toString() {
        return TFloat.toString(this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TFloat && ((TFloat)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return TFloat.floatToIntBits(this.value);
    }

    @GeneratedBy(value=FloatNativeGenerator.class)
    public static native boolean isNaN(float var0);

    @GeneratedBy(value=FloatNativeGenerator.class)
    public static native boolean isInfinite(float var0);

    @GeneratedBy(value=FloatNativeGenerator.class)
    private static native float getNaN();

    public static float parseFloat(TString string) throws TNumberFormatException {
        string = string.trim();
        boolean negative = false;
        int index = 0;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        char c = string.charAt(index);
        if (c < '0' || c > '9') {
            throw new TNumberFormatException();
        }
        int mantissa = 0;
        int exp = 0;
        while (string.charAt(index) == '0') {
            if (++index != string.length()) continue;
            return 0.0f;
        }
        while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
            if ((double)mantissa < 1.0E8) {
                mantissa = mantissa * 10 + (c - 48);
            } else {
                ++exp;
            }
            ++index;
        }
        if (index < string.length() && string.charAt(index) == '.') {
            ++index;
            boolean hasOneDigit = false;
            while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
                if ((double)mantissa < 1.0E38) {
                    mantissa = mantissa * 10 + (c - 48);
                    --exp;
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
        }
        if (index < string.length()) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new TNumberFormatException();
            }
            boolean negativeExp = false;
            if (string.charAt(++index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            boolean hasOneDigit = false;
            while (index < string.length() && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new TNumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        if (exp > 38 || exp == 38 && mantissa > 34028234) {
            return !negative ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (negative) {
            mantissa = -mantissa;
        }
        return (float)mantissa * TFloat.decimalExponent(exp);
    }

    private static float decimalExponent(int n) {
        float d;
        if (n < 0) {
            d = 0.1f;
            n = -n;
        } else {
            d = 10.0f;
        }
        float result = 1.0f;
        while (n != 0) {
            if (n % 2 != 0) {
                result *= d;
            }
            d *= d;
            n /= 2;
        }
        return result;
    }

    public static TFloat valueOf(TString s) throws TNumberFormatException {
        return TFloat.valueOf(TFloat.parseFloat(s));
    }

    public boolean isNaN() {
        return TFloat.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TFloat.isInfinite(this.value);
    }

    public static int compare(float f1, float f2) {
        return f1 > f2 ? 1 : (f2 < f1 ? -1 : 0);
    }

    @Override
    public int compareTo(TFloat other) {
        return TFloat.compare(this.value, other.value);
    }

    public static int floatToRawIntBits(float value) {
        return TFloat.floatToIntBits(value);
    }

    public static int floatToIntBits(float value) {
        if (value == Float.POSITIVE_INFINITY) {
            return 2139095040;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return -8388608;
        }
        if (TFloat.isNaN(value)) {
            return 2143289344;
        }
        float abs = TMath.abs(value);
        int exp = TMath.getExponent(abs);
        int negExp = -exp + 23;
        if (exp < -126) {
            exp = -127;
            negExp = 149;
        }
        float doubleMantissa = negExp <= 126 ? abs * TFloat.binaryExponent(negExp) : abs * 8.507059E37f * TFloat.binaryExponent(negExp - 126);
        int mantissa = (int)(doubleMantissa + 0.5f) & 0x7FFFFF;
        return mantissa | exp + 127 << 23 | (value < 0.0f || 1.0f / value == Float.NEGATIVE_INFINITY ? Integer.MIN_VALUE : 0);
    }

    public static float intBitsToFloat(int bits) {
        if ((bits & 0x7F800000) == 2139095040) {
            if (bits == 2139095040) {
                return Float.POSITIVE_INFINITY;
            }
            if (bits == -8388608) {
                return Float.NEGATIVE_INFINITY;
            }
            return NaN;
        }
        boolean negative = (bits & Integer.MIN_VALUE) != 0;
        int rawExp = bits >> 23 & 0xFF;
        int mantissa = bits & 0x7FFFFF;
        mantissa = rawExp == 0 ? (mantissa <<= 1) : (int)((long)mantissa | 0x800000L);
        float value = (float)mantissa * TFloat.binaryExponent(rawExp - 127 - 23);
        return !negative ? value : -value;
    }

    private static float binaryExponent(int n) {
        float result = 1.0f;
        if (n >= 0) {
            float d = 2.0f;
            while (n != 0) {
                if (n % 2 != 0) {
                    result *= d;
                }
                n /= 2;
                d *= d;
            }
        } else {
            n = -n;
            float d = 0.5f;
            while (n != 0) {
                if (n % 2 != 0) {
                    result *= d;
                }
                n /= 2;
                d *= d;
            }
        }
        return result;
    }

    public static TString toHexString(float f) {
        if (TFloat.isNaN(f)) {
            return TString.wrap("NaN");
        }
        if (TFloat.isInfinite(f)) {
            return f > 0.0f ? TString.wrap("Infinity") : TString.wrap("-Infinity");
        }
        char[] buffer = new char[18];
        int sz = 0;
        int bits = TFloat.floatToIntBits(f);
        boolean subNormal = false;
        int exp = (bits >>> 23 & 0xFF) - 127;
        int mantissa = (bits & 0x7FFFFF) << 1;
        if (exp == -127) {
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 6; ++i) {
            int digit = mantissa & 0xF;
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if (((long)bits & 0x80000000L) != 0L) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 100;
        boolean first = true;
        for (int i = 0; i < 3; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new TString(buffer, 0, sz);
    }
}

