/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;

class TIntBufferOverArray
extends TIntBufferImpl {
    boolean readOnly;
    int start;
    int[] array;

    public TIntBufferOverArray(int capacity) {
        this(0, capacity, new int[capacity], 0, capacity, false);
    }

    public TIntBufferOverArray(int start, int capacity, int[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TIntBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TIntBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    int getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, int value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    int[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

