/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteBufferImpl;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TFloatBuffer;
import org.teavm.classlib.java.nio.TFloatBufferOverByteBuffer;

class TFloatBufferOverByteBufferLittleEndian
extends TFloatBufferOverByteBuffer {
    public TFloatBufferOverByteBufferLittleEndian(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(start, capacity, byteBuffer, position, limit, readOnly);
    }

    @Override
    TFloatBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TFloatBufferOverByteBufferLittleEndian(this.start + start * 4, capacity, this.byteByffer, position, limit, readOnly);
    }

    @Override
    float getElement(int index) {
        int value = (this.byteByffer.array[this.start + index * 4] & 0xFF) << 24 | (this.byteByffer.array[this.start + index * 4 + 1] & 0xFF) << 16 | (this.byteByffer.array[this.start + index * 4 + 2] & 0xFF) << 8 | this.byteByffer.array[this.start + index * 4 + 3] & 0xFF;
        return Float.intBitsToFloat(value);
    }

    @Override
    void putElement(int index, float f) {
        int value = Float.floatToIntBits(f);
        this.byteByffer.array[this.start + index * 4] = (byte)(value >> 24);
        this.byteByffer.array[this.start + index * 4 + 1] = (byte)(value >> 16);
        this.byteByffer.array[this.start + index * 4 + 2] = (byte)(value >> 8);
        this.byteByffer.array[this.start + index * 4 + 3] = (byte)value;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.LITTLE_ENDIAN;
    }
}

