/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.javascript.spi.Rename;

public abstract class TEnum<E extends TEnum<E>>
extends TObject
implements TComparable<E>,
TSerializable {
    private TString name;
    private int ordinal;

    protected TEnum(TString name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public final TString name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Rename(value="clone")
    protected final TObject clone0() throws TCloneNotSupportedException {
        throw new TCloneNotSupportedException();
    }

    public final TClass<E> getDeclaringClass() {
        return (TClass)((Object)this.getClass());
    }

    @Override
    public final int compareTo(E o) {
        if (((TEnum)o).getDeclaringClass() != this.getDeclaringClass()) {
            throw new TIllegalArgumentException(TString.wrap("Can't compare " + this.getDeclaringClass().getName().toString() + " to " + ((TEnum)o).getDeclaringClass().getName().toString()));
        }
        return TInteger.compare(this.ordinal, ((TEnum)o).ordinal());
    }

    public static <T extends TEnum<T>> T valueOf(TClass<T> enumType, TString name) {
        TEnum[] constants = (TEnum[])enumType.getEnumConstants();
        if (constants == null) {
            throw new TIllegalArgumentException(TString.wrap("Class does not represent enum: " + enumType.getName()));
        }
        for (TEnum constant : constants) {
            if (!constant.name().equals(name)) continue;
            return (T)constant;
        }
        throw new TIllegalArgumentException(TString.wrap("Enum " + enumType.getName() + " does not have the " + name + "constant"));
    }
}

