/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.currency;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.teavm.classlib.impl.currency.CurrencyResource;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CurrenciesGenerator
implements MetadataGenerator {
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        Document doc;
        try (InputStream input = context.getClassLoader().getResourceAsStream("org/teavm/classlib/impl/currency/iso4217.xml");){
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(input);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error reading ISO 4217 medata from file");
        }
        ResourceArray currencies = context.createResourceArray();
        Element root = doc.getDocumentElement();
        for (Element elem : this.childElements(root)) {
            if (!elem.getTagName().equals("CcyTbl")) continue;
            this.parseCurrencies(context, elem, (ResourceArray<CurrencyResource>)currencies);
        }
        return currencies;
    }

    private void parseCurrencies(MetadataGeneratorContext context, Element tableElem, ResourceArray<CurrencyResource> currencies) {
        for (Element currencyElem : this.childElements(tableElem)) {
            if (!currencyElem.getTagName().equals("CcyNtry")) continue;
            CurrencyResource currency = (CurrencyResource)context.createResource(CurrencyResource.class);
            for (Element propertyElem : this.childElements(currencyElem)) {
                switch (propertyElem.getTagName()) {
                    case "Ccy": {
                        currency.setCode(this.getText(propertyElem));
                        break;
                    }
                    case "CcyNbr": {
                        currency.setNumericCode(Integer.parseInt(this.getText(propertyElem)));
                        break;
                    }
                    case "CcyMnrUnts": {
                        String value = this.getText(propertyElem);
                        if (value.equals("N.A.")) {
                            currency.setFractionDigits(-1);
                            break;
                        }
                        currency.setFractionDigits(Integer.parseInt(value));
                    }
                }
            }
            currencies.add((Resource)currency);
        }
    }

    private Iterable<Element> childElements(final Element parent) {
        return new Iterable<Element>(){
            NodeList nodes;
            {
                this.nodes = parent.getChildNodes();
            }

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    int index = -1;
                    {
                        this.following();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Element next() {
                        Element result = (Element)nodes.item(this.index);
                        this.following();
                        return result;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index < nodes.getLength();
                    }

                    private void following() {
                        while (++this.index < nodes.getLength() && nodes.item(this.index).getNodeType() != 1) {
                        }
                    }
                };
            }
        };
    }

    private String getText(Element element) {
        StringBuilder sb = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData cdata = (CharacterData)child;
                    sb.append(cdata.getData());
                    continue block4;
                }
                case 5: {
                    EntityReference ref = (EntityReference)child;
                    sb.append(ref.getNodeValue());
                }
            }
        }
        return sb.toString();
    }
}

