/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.util.TDate;
import org.teavm.classlib.java.util.TGregorianCalendar;
import org.teavm.classlib.java.util.TLocale;
import org.teavm.platform.metadata.IntResource;
import org.teavm.platform.metadata.ResourceMap;

public abstract class TCalendar
implements TSerializable,
TCloneable,
TComparable<TCalendar> {
    protected boolean areFieldsSet = false;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected boolean isTimeSet = false;
    protected long time;
    transient int lastTimeFieldSet;
    transient int lastDateFieldSet;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int AM = 0;
    public static final int PM = 1;
    private static String[] fieldNames = new String[]{"ERA=", "YEAR=", "MONTH=", "WEEK_OF_YEAR=", "WEEK_OF_MONTH=", "DAY_OF_MONTH=", "DAY_OF_YEAR=", "DAY_OF_WEEK=", "DAY_OF_WEEK_IN_MONTH=", "AM_PM=", "HOUR=", "HOUR_OF_DAY", "MINUTE=", "SECOND=", "MILLISECOND=", "ZONE_OFFSET=", "DST_OFFSET="};

    protected TCalendar() {
        this(TLocale.getDefault());
    }

    protected TCalendar(TLocale locale) {
        this.setLenient(true);
        this.setFirstDayOfWeek(TCalendar.resolveFirstDayOfWeek(locale));
        this.setMinimalDaysInFirstWeek(TCalendar.resolveMinimalDaysInFirstWeek(locale));
    }

    private static String resolveCountry(TLocale locale) {
        String country = locale.getCountry();
        if (country.isEmpty()) {
            String subtags = CLDRHelper.getLikelySubtags(locale.getLanguage());
            int index = subtags.lastIndexOf(95);
            country = index > 0 ? subtags.substring(index + 1) : "";
        }
        return country;
    }

    private static int resolveFirstDayOfWeek(TLocale locale) {
        String country = TCalendar.resolveCountry(locale);
        ResourceMap<IntResource> dayMap = CLDRHelper.getFirstDayOfWeek();
        return dayMap.has(country) ? ((IntResource)dayMap.get(country)).getValue() : ((IntResource)dayMap.get("001")).getValue();
    }

    private static int resolveMinimalDaysInFirstWeek(TLocale locale) {
        String country = TCalendar.resolveCountry(locale);
        ResourceMap<IntResource> dayMap = CLDRHelper.getMinimalDaysInFirstWeek();
        return dayMap.has(country) ? ((IntResource)dayMap.get(country)).getValue() : ((IntResource)dayMap.get("001")).getValue();
    }

    public abstract void add(int var1, int var2);

    public boolean after(Object calendar) {
        if (!(calendar instanceof TCalendar)) {
            return false;
        }
        return this.getTimeInMillis() > ((TCalendar)calendar).getTimeInMillis();
    }

    public boolean before(Object calendar) {
        if (!(calendar instanceof TCalendar)) {
            return false;
        }
        return this.getTimeInMillis() < ((TCalendar)calendar).getTimeInMillis();
    }

    public final void clear() {
        for (int i = 0; i < 17; ++i) {
            this.fields[i] = 0;
            this.isSet[i] = false;
        }
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public final void clear(int field) {
        this.fields[field] = 0;
        this.isSet[field] = false;
        this.isTimeSet = false;
        this.areFieldsSet = false;
    }

    public Object clone() {
        try {
            TCalendar clone = (TCalendar)super.clone();
            clone.fields = (int[])this.fields.clone();
            clone.isSet = (boolean[])this.isSet.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
        }
    }

    protected abstract void computeFields();

    protected abstract void computeTime();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TCalendar)) {
            return false;
        }
        TCalendar cal = (TCalendar)object;
        return this.getTimeInMillis() == cal.getTimeInMillis() && this.isLenient() == cal.isLenient() && this.getFirstDayOfWeek() == cal.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == cal.getMinimalDaysInFirstWeek();
    }

    public int get(int field) {
        this.complete();
        return this.fields[field];
    }

    public int getActualMaximum(int field) {
        int value;
        int next = this.getLeastMaximum(field);
        if (this.getMaximum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, true);
        } while ((next = this.get(field)) > value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public int getActualMinimum(int field) {
        int value;
        int next = this.getGreatestMinimum(field);
        if (this.getMinimum(field) == next) {
            return next;
        }
        this.complete();
        long orgTime = this.time;
        this.set(field, next);
        do {
            value = next;
            this.roll(field, false);
        } while ((next = this.get(field)) < value);
        this.time = orgTime;
        this.areFieldsSet = false;
        return value;
    }

    public static synchronized TLocale[] getAvailableLocales() {
        return TLocale.getAvailableLocales();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public abstract int getGreatestMinimum(int var1);

    public static synchronized TCalendar getInstance() {
        return new TGregorianCalendar();
    }

    public static synchronized TCalendar getInstance(TLocale locale) {
        return new TGregorianCalendar(locale);
    }

    public abstract int getLeastMaximum(int var1);

    public abstract int getMaximum(int var1);

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public final TDate getTime() {
        return new TDate(this.getTimeInMillis());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }

    public int hashCode() {
        return (this.isLenient() ? 1237 : 1231) + this.getFirstDayOfWeek() + this.getMinimalDaysInFirstWeek();
    }

    protected final int internalGet(int field) {
        return this.fields[field];
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final boolean isSet(int field) {
        return this.isSet[field];
    }

    public void roll(int field, int value) {
        boolean increment = value >= 0;
        int count = increment ? value : -value;
        for (int i = 0; i < count; ++i) {
            this.roll(field, increment);
        }
    }

    public abstract void roll(int var1, boolean var2);

    public void set(int field, int value) {
        this.fields[field] = value;
        this.isSet[field] = true;
        this.isTimeSet = false;
        this.areFieldsSet = false;
        if (field > 2 && field < 9) {
            this.lastDateFieldSet = field;
        }
        if (field == 10 || field == 11) {
            this.lastTimeFieldSet = field;
        }
        if (field == 9) {
            this.lastTimeFieldSet = 10;
        }
    }

    public final void set(int year, int month, int day) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute) {
        this.set(year, month, day);
        this.set(11, hourOfDay);
        this.set(12, minute);
    }

    public final void set(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.set(year, month, day, hourOfDay, minute);
        this.set(13, second);
    }

    public void setFirstDayOfWeek(int value) {
        this.firstDayOfWeek = value;
    }

    public void setLenient(boolean value) {
        this.lenient = value;
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.minimalDaysInFirstWeek = value;
    }

    public final void setTime(TDate date) {
        this.setTimeInMillis(date.getTime());
    }

    public void setTimeInMillis(long milliseconds) {
        if (!this.isTimeSet || !this.areFieldsSet || this.time != milliseconds) {
            this.time = milliseconds;
            this.isTimeSet = true;
            this.areFieldsSet = false;
            this.complete();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getName() + "[time=" + (this.isTimeSet ? String.valueOf(this.time) : "?") + ",areFieldsSet=" + this.areFieldsSet + ",lenient=" + this.lenient + ",firstDayOfWeek=" + this.firstDayOfWeek + ",minimalDaysInFirstWeek=" + this.minimalDaysInFirstWeek);
        for (int i = 0; i < 17; ++i) {
            result.append(',');
            result.append(fieldNames[i]);
            result.append('=');
            if (this.isSet[i]) {
                result.append(this.fields[i]);
                continue;
            }
            result.append('?');
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public int compareTo(TCalendar anotherCalendar) {
        long anotherTimeInMillis;
        if (null == anotherCalendar) {
            throw new NullPointerException();
        }
        long timeInMillis = this.getTimeInMillis();
        if (timeInMillis > (anotherTimeInMillis = anotherCalendar.getTimeInMillis())) {
            return 1;
        }
        if (timeInMillis == anotherTimeInMillis) {
            return 0;
        }
        return -1;
    }
}

