/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.model.MethodReference;

public class DateNativeGenerator
implements Generator,
DependencyPlugin {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "buildNumericTime": {
                this.generateBuildNumericTime(context, writer);
                break;
            }
            case "parseNumericTime": {
                this.generateParseNumericTime(context, writer);
                break;
            }
            case "buildNumericUTC": {
                this.generateBuildNumericUTC(context, writer);
                break;
            }
            case "getFullYear": 
            case "getMonth": 
            case "getDate": 
            case "getDay": 
            case "getHours": 
            case "getMinutes": 
            case "getSeconds": 
            case "getTimezoneOffset": {
                this.generateGetMethod(context, writer, methodRef.getName());
                break;
            }
            case "setFullYear": 
            case "setMonth": 
            case "setDate": 
            case "setHours": 
            case "setMinutes": 
            case "setSeconds": {
                this.generateSetMethod(context, writer, methodRef.getName());
                break;
            }
            case "toString": 
            case "toGMTString": {
                this.generateToString(context, writer, methodRef.getName());
                break;
            }
            case "toLocaleFormat": {
                this.generateToLocaleFormat(context, writer);
            }
        }
    }

    public void methodAchieved(DependencyAgent agent, MethodDependency method) {
        switch (method.getMethod().getName()) {
            case "toString": 
            case "toLocaleFormat": 
            case "toGMTString": {
                method.getResult().propagate(agent.getType("java.lang.String"));
            }
        }
    }

    private void generateBuildNumericTime(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return new Date(").append(context.getParameterName(1));
        for (int i = 2; i <= 6; ++i) {
            writer.append(',').ws().append(context.getParameterName(i));
        }
        writer.append(").getTime();").softNewLine();
    }

    private void generateParseNumericTime(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return Date.parse(").append(context.getParameterName(1)).append(");").softNewLine();
    }

    private void generateBuildNumericUTC(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return Date.UTC(").append(context.getParameterName(1));
        for (int i = 2; i <= 6; ++i) {
            writer.append(',').ws().append(context.getParameterName(i));
        }
        writer.append(").getTime();").softNewLine();
    }

    private void generateGetMethod(GeneratorContext context, SourceWriter writer, String methodName) throws IOException {
        writer.append("return new Date(").append(context.getParameterName(1)).append(").").append(methodName).append("();").softNewLine();
    }

    private void generateSetMethod(GeneratorContext context, SourceWriter writer, String methodName) throws IOException {
        writer.append("var date = new Date(").append(context.getParameterName(1)).append(");").softNewLine();
        writer.append("return date.").append(methodName).append("(").append(context.getParameterName(2)).append(");").softNewLine();
    }

    private void generateToString(GeneratorContext context, SourceWriter writer, String method) throws IOException {
        writer.append("return $rt_str(new Date(").append(context.getParameterName(1)).append(").").append(method).append("());").softNewLine();
    }

    private void generateToLocaleFormat(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return $rt_str(new Date(").append(context.getParameterName(1)).append(").toLocaleFormat($rt_ustr(").append(context.getParameterName(2)).append(")));").softNewLine();
    }
}

