/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.LongNativeGenerator;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.javascript.ni.GeneratedBy;
import org.teavm.javascript.ni.Rename;

public class TLong
extends TNumber
implements TComparable<TLong> {
    public static final long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final TClass<TLong> TYPE = TClass.longClass();
    public static final int SIZE = 64;
    private long value;

    public TLong(long value) {
        this.value = value;
    }

    public TLong(TString value) throws TNumberFormatException {
        this(TLong.parseLong(value));
    }

    public static TLong valueOf(long value) {
        return new TLong(value);
    }

    public static long parseLong(TString s, int radix) throws TNumberFormatException {
        if (radix < 2 || radix > 36) {
            throw new TNumberFormatException(TString.wrap("Illegal radix: " + radix));
        }
        if (s == null || s.isEmpty()) {
            throw new TNumberFormatException(TString.wrap("String is null or empty"));
        }
        boolean negative = false;
        int index = 0;
        switch (s.charAt(0)) {
            case '-': {
                negative = true;
                index = 1;
                break;
            }
            case '+': {
                index = 1;
            }
        }
        long value = 0L;
        while (index < s.length()) {
            int digit;
            if ((digit = TCharacter.getNumericValue(s.charAt(index++))) < 0) {
                throw new TNumberFormatException(TString.wrap("String contains invalid digits: " + s));
            }
            if (digit >= radix) {
                throw new TNumberFormatException(TString.wrap("String contains digits out of radix " + radix + ": " + s));
            }
            if ((value = (long)radix * value + (long)digit) >= 0L) continue;
            if (index == s.length() && value == Long.MIN_VALUE && negative) {
                return Long.MIN_VALUE;
            }
            throw new TNumberFormatException(TString.wrap("The value is too big for int type: " + s));
        }
        return negative ? -value : value;
    }

    public static long parseLong(TString s) throws TNumberFormatException {
        return TLong.parseLong(s, 10);
    }

    public static TLong valueOf(TString s, int radix) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s, radix));
    }

    public static TLong valueOf(TString s) throws TNumberFormatException {
        return TLong.valueOf(TLong.parseLong(s));
    }

    public static TLong decode(TString nm) throws TNumberFormatException {
        if (nm == null || nm.isEmpty()) {
            throw new TNumberFormatException(TString.wrap("Can't parse empty or null string"));
        }
        int index = 0;
        boolean negaive = false;
        if (nm.charAt(index) == '+') {
            ++index;
        } else if (nm.charAt(index) == '-') {
            ++index;
            negaive = true;
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException(TString.wrap("The string does not represent a number"));
        }
        int radix = 10;
        if (nm.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (nm.charAt(index) == '0') {
            if (++index == nm.length()) {
                return TLong.valueOf(0L);
            }
            if (nm.charAt(index) == 'x' || nm.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= nm.length()) {
            throw new TNumberFormatException(TString.wrap("The string does not represent a number"));
        }
        long value = 0L;
        while (index < nm.length()) {
            int digit;
            if ((digit = TLong.decodeDigit(nm.charAt(index++))) >= radix) {
                throw new TNumberFormatException(TString.wrap("The string does not represent a number"));
            }
            if ((value = value * (long)radix + (long)digit) >= 0L) continue;
            if (negaive && value == Long.MIN_VALUE && index == nm.length()) {
                return TLong.valueOf(Long.MIN_VALUE);
            }
            throw new TNumberFormatException(TString.wrap("The string represents a too big number"));
        }
        return TLong.valueOf(negaive ? -value : value);
    }

    private static int decodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10;
        }
        return 255;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static TString toString(long i, int radix) {
        return TString.wrap(new TStringBuilder().insert(0, i, radix).toString());
    }

    public static TString toHexString(long i) {
        return TLong.toString(i, 16);
    }

    public static TString toOctalString(long i) {
        return TLong.toString(i, 8);
    }

    public static TString toBinaryString(long i) {
        return TLong.toString(i, 2);
    }

    public static TString toString(long value) {
        return TString.wrap(new TStringBuilder().append(value).toString());
    }

    @Override
    @Rename(value="toString")
    public TString toString0() {
        return TLong.toString(this.value);
    }

    @Override
    @GeneratedBy(value=LongNativeGenerator.class)
    public native int hashCode();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TLong && ((TLong)other).value == this.value;
    }

    @GeneratedBy(value=LongNativeGenerator.class)
    public static native int compare(long var0, long var2);

    @Override
    public int compareTo(TLong other) {
        return TLong.compare(this.value, other.value);
    }

    public static TLong getLong(TString nm) {
        return TLong.getLong(nm, null);
    }

    public static TLong getLong(TString nm, long val) {
        return TLong.getLong(nm, TLong.valueOf(val));
    }

    public static TLong getLong(TString nm, TLong val) {
        TString result = TSystem.getProperty(nm);
        return result != null ? TLong.valueOf(result) : val;
    }

    public static long highestOneBit(long i) {
        return Long.MIN_VALUE >>> TLong.numberOfLeadingZeros(i);
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 0;
        if (i >>> 32 != 0L) {
            i >>>= 32;
            n |= 0x20;
        }
        if (i >>> 16 != 0L) {
            i >>>= 16;
            n |= 0x10;
        }
        if (i >>> 8 != 0L) {
            i >>>= 8;
            n |= 8;
        }
        if (i >>> 4 != 0L) {
            i >>>= 4;
            n |= 4;
        }
        if (i >>> 2 != 0L) {
            i >>>= 2;
            n |= 2;
        }
        if (i >>> 1 != 0L) {
            i >>>= 1;
            n |= 1;
        }
        return 64 - n - 1;
    }

    public static int numberOfTrailingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 0;
        if (i << 32 != 0L) {
            i <<= 32;
            n |= 0x20;
        }
        if (i << 16 != 0L) {
            i <<= 16;
            n |= 0x10;
        }
        if (i << 8 != 0L) {
            i <<= 8;
            n |= 8;
        }
        if (i << 4 != 0L) {
            i <<= 4;
            n |= 4;
        }
        if (i << 2 != 0L) {
            i <<= 2;
            n |= 2;
        }
        if (i << 1 != 0L) {
            i <<= 1;
            n |= 1;
        }
        return 64 - n - 1;
    }

    public static long lowestOneBit(long i) {
        return 1L << TLong.numberOfTrailingZeros(i);
    }

    public static int bitCount(long i) {
        i = ((i & 0xAAAAAAAAAAAAAAAAL) >> 1) + (i & 0x5555555555555555L);
        i = ((i & 0xCCCCCCCCCCCCCCCCL) >> 2) + (i & 0x3333333333333333L);
        i = ((i & 0x3030303030303030L) >> 4) + (i & 0x303030303030303L);
        i = ((i & 0x700070007000700L) >> 8) + (i & 0x7000700070007L);
        i = ((i & 0xF0000000F0000L) >> 16) + (i & 0xF0000000FL);
        i = ((i & 0x1F00000000L) >> 32) + (i & 0x1FL);
        return (int)i;
    }

    public static long rotateLeft(long i, int distance) {
        return i << (distance &= 0x3F) | i >>> 64 - distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> (distance &= 0x3F) | i << 64 - distance;
    }

    public static long reverse(long i) {
        i = (i & 0xAAAAAAAAAAAAAAAAL) >> 1 | (i & 0x5555555555555555L) << 1;
        i = (i & 0xCCCCCCCCCCCCCCCCL) >> 2 | (i & 0x3333333333333333L) << 2;
        i = (i & 0xF0F0F0F0F0F0F0F0L) >> 4 | (i & 0xF0F0F0F0F0F0F0FL) << 4;
        i = (i & 0xFF00FF00FF00FF00L) >> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = (i & 0xFFFF0000FFFF0000L) >> 32 | (i & 0xFFFF0000FFFFL) << 32;
        return i;
    }

    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FF00L) >> 8 | (i & 0xFF00FF00FF00FFL) << 8;
        i = (i & 0xFFFF0000FFFF0000L) >> 16 | (i & 0xFFFF0000FFFFL) << 16;
        i = i >> 32 | i << 32;
        return i;
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }
}

