/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;

public class EnumDependencySupport
implements DependencyListener {
    private DependencyNode allEnums;
    private volatile DependencyStack enumConstantsStack;

    public void started(DependencyAgent agent) {
        this.allEnums = agent.createNode();
    }

    public void classAchieved(DependencyAgent agent, String className) {
        MethodReader method;
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null || cls.getParent() == null || !cls.getParent().equals("java.lang.Enum")) {
            return;
        }
        this.allEnums.propagate(agent.getType(className));
        if (this.enumConstantsStack != null && (method = cls.getMethod(new MethodDescriptor("values", new ValueType[]{ValueType.arrayOf((ValueType)ValueType.object((String)cls.getName()))}))) != null) {
            agent.linkMethod(method.getReference(), this.enumConstantsStack).use();
        }
    }

    public void methodAchieved(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().getClassName().equals("java.lang.Class") && method.getReference().getName().equals("getEnumConstantsImpl")) {
            this.allEnums.connect(method.getResult().getArrayItem());
            method.getResult().propagate(agent.getType("[java.lang.Enum"));
            this.enumConstantsStack = method.getStack();
            for (String cls : agent.getAchievableClasses()) {
                this.classAchieved(agent, cls);
            }
        }
    }

    public void fieldAchieved(DependencyAgent agent, FieldDependency field) {
    }
}

