/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.File;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.ComponentHelper;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;
import org.talend.sdk.component.tools.SvgValidator;
import org.talend.sdk.component.tools.spi.ValidationExtension;
import org.talend.sdk.component.tools.validator.Validators;

public class ComponentValidator
extends BaseTask {
    private final Configuration configuration;
    private final Log log;
    private final ParameterModelService parameterModelService = new ParameterModelService((PropertyEditorRegistry)new EnrichedPropertyEditorRegistry());
    private final SvgValidator validator = new SvgValidator();
    private final Map<Class<?>, List<ParameterMeta>> parametersCache = new HashMap();
    private final List<ValidationExtension> extensions;

    public ComponentValidator(Configuration configuration, File[] classes, Object log) {
        super(classes);
        this.configuration = configuration;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.extensions = StreamSupport.stream(ServiceLoader.load(ValidationExtension.class).spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public void run() {
        AnnotationFinder finder = this.newFinder();
        List<Class<?>> components = ComponentHelper.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream()).collect(Collectors.toList());
        components.forEach(c -> this.log.debug("Found component: " + c));
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        Validators.ValidatorHelper helper = new Validators.ValidatorHelper(){

            @Override
            public boolean isService(Parameter parameter) {
                return ComponentValidator.this.parameterModelService.isService(new ParameterModelService.Param(parameter));
            }

            @Override
            public ResourceBundle findResourceBundle(Class<?> component) {
                return ComponentValidator.this.findResourceBundle(component);
            }

            @Override
            public String validateFamilyI18nKey(Class<?> clazz, String ... keys) {
                return ComponentValidator.this.validateFamilyI18nKey(clazz, keys);
            }

            @Override
            public List<ParameterMeta> buildOrGetParameters(Class<?> c) {
                return ComponentValidator.this.buildOrGetParameters(c);
            }

            @Override
            public String validateIcon(Icon annotation, Collection<String> errors) {
                return ComponentValidator.this.validateIcon(annotation, errors);
            }

            @Override
            public ParameterModelService getParameterModelService() {
                return ComponentValidator.this.parameterModelService;
            }

            @Override
            public Stream<File> componentClassFiles() {
                if (ComponentValidator.this.classes == null) {
                    return Stream.empty();
                }
                return Stream.of(ComponentValidator.this.classes);
            }
        };
        Validators validators = Validators.build(this.configuration, helper, this.extensions);
        Set<String> errorsFromValidator = validators.validate(finder, components);
        errors.addAll(errorsFromValidator);
        if (!errors.isEmpty()) {
            List<String> preparedErrors = errors.stream().map(it -> it.replace("java.lang.", "").replace("java.util.", "")).collect(Collectors.toList());
            preparedErrors.forEach(this.log::error);
            throw new IllegalStateException("Some error were detected:" + preparedErrors.stream().collect(Collectors.joining("\n- ", "\n- ", "")));
        }
        this.log.info("Validated components: " + components.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
    }

    private String validateIcon(Icon annotation, Collection<String> errors) {
        if (this.classes.length == 0) {
            return null;
        }
        if (annotation.value() == Icon.IconType.CUSTOM) {
            String icon = annotation.custom();
            Set svgs = Stream.of(this.classes).map(it -> new File((File)it, "icons/" + icon + ".svg")).filter(File::exists).collect(ComponentValidator.toSet());
            if (svgs.isEmpty()) {
                this.log.error("No 'icons/" + icon + ".svg' found, this will run in degraded mode in Talend Cloud");
            } else if (this.configuration.isValidateSvg()) {
                errors.addAll(svgs.stream().flatMap(this::validateSvg).collect(ComponentValidator.toSet()));
            }
            if (Stream.of(this.classes).map(it -> new File((File)it, "icons/" + icon + "_icon32.png")).noneMatch(File::exists)) {
                return "No icon: '" + icon + "' found, did you create - or generated with svg2png - 'icons/" + icon + "_icon32.png' in resources?";
            }
        }
        return null;
    }

    private Stream<String> validateSvg(File file) {
        return this.validator.validate(file.toPath());
    }

    private List<ParameterMeta> buildOrGetParameters(Class<?> c) {
        return this.parametersCache.computeIfAbsent(c, k -> this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)c), Optional.ofNullable(c.getPackage()).map(Package::getName).orElse(""), new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools"))));
    }

    private String validateFamilyI18nKey(Class<?> clazz, String ... keys) {
        Class<?> pck = ComponentHelper.findPackageOrFail(clazz, this.apiTester(Components.class), Components.class.getName());
        String family = pck.getAnnotation(Components.class).family();
        String baseName = Optional.ofNullable(pck.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.findResourceBundle(pck);
        if (bundle == null) {
            return "No resource bundle for " + clazz.getName() + " translations, you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        Collection missingKeys = Stream.of(keys).map(key -> key.replace("${family}", family)).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + String.join((CharSequence)"\n", missingKeys);
        }
        return null;
    }

    private static <T> Collector<T, ?, Set<T>> toSet() {
        return Collectors.toCollection(TreeSet::new);
    }

    public static class Configuration {
        private boolean validateFamily;
        private boolean validateSerializable;
        private boolean validateInternationalization;
        private boolean validateHttpClient;
        private boolean validateModel;
        private boolean validateMetadata;
        private boolean validateComponent;
        private boolean validateDataStore;
        private boolean validateDataSet;
        private boolean validateActions;
        private boolean validateDocumentation;
        private boolean validateWording;
        private boolean validateLayout;
        private boolean validateOptionNames;
        private boolean validateLocalConfiguration;
        private boolean validateOutputConnection;
        private boolean validatePlaceholder;
        private boolean validateSvg;
        private boolean validateNoFinalOption;
        private String pluginId;
        private boolean validateExceptions;
        private boolean failOnValidateExceptions;
        private boolean validateRecord;
        private boolean validateSchema;

        public boolean isValidateFamily() {
            return this.validateFamily;
        }

        public boolean isValidateSerializable() {
            return this.validateSerializable;
        }

        public boolean isValidateInternationalization() {
            return this.validateInternationalization;
        }

        public boolean isValidateHttpClient() {
            return this.validateHttpClient;
        }

        public boolean isValidateModel() {
            return this.validateModel;
        }

        public boolean isValidateMetadata() {
            return this.validateMetadata;
        }

        public boolean isValidateComponent() {
            return this.validateComponent;
        }

        public boolean isValidateDataStore() {
            return this.validateDataStore;
        }

        public boolean isValidateDataSet() {
            return this.validateDataSet;
        }

        public boolean isValidateActions() {
            return this.validateActions;
        }

        public boolean isValidateDocumentation() {
            return this.validateDocumentation;
        }

        public boolean isValidateWording() {
            return this.validateWording;
        }

        public boolean isValidateLayout() {
            return this.validateLayout;
        }

        public boolean isValidateOptionNames() {
            return this.validateOptionNames;
        }

        public boolean isValidateLocalConfiguration() {
            return this.validateLocalConfiguration;
        }

        public boolean isValidateOutputConnection() {
            return this.validateOutputConnection;
        }

        public boolean isValidatePlaceholder() {
            return this.validatePlaceholder;
        }

        public boolean isValidateSvg() {
            return this.validateSvg;
        }

        public boolean isValidateNoFinalOption() {
            return this.validateNoFinalOption;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public boolean isValidateExceptions() {
            return this.validateExceptions;
        }

        public boolean isFailOnValidateExceptions() {
            return this.failOnValidateExceptions;
        }

        public boolean isValidateRecord() {
            return this.validateRecord;
        }

        public boolean isValidateSchema() {
            return this.validateSchema;
        }

        public void setValidateFamily(boolean validateFamily) {
            this.validateFamily = validateFamily;
        }

        public void setValidateSerializable(boolean validateSerializable) {
            this.validateSerializable = validateSerializable;
        }

        public void setValidateInternationalization(boolean validateInternationalization) {
            this.validateInternationalization = validateInternationalization;
        }

        public void setValidateHttpClient(boolean validateHttpClient) {
            this.validateHttpClient = validateHttpClient;
        }

        public void setValidateModel(boolean validateModel) {
            this.validateModel = validateModel;
        }

        public void setValidateMetadata(boolean validateMetadata) {
            this.validateMetadata = validateMetadata;
        }

        public void setValidateComponent(boolean validateComponent) {
            this.validateComponent = validateComponent;
        }

        public void setValidateDataStore(boolean validateDataStore) {
            this.validateDataStore = validateDataStore;
        }

        public void setValidateDataSet(boolean validateDataSet) {
            this.validateDataSet = validateDataSet;
        }

        public void setValidateActions(boolean validateActions) {
            this.validateActions = validateActions;
        }

        public void setValidateDocumentation(boolean validateDocumentation) {
            this.validateDocumentation = validateDocumentation;
        }

        public void setValidateWording(boolean validateWording) {
            this.validateWording = validateWording;
        }

        public void setValidateLayout(boolean validateLayout) {
            this.validateLayout = validateLayout;
        }

        public void setValidateOptionNames(boolean validateOptionNames) {
            this.validateOptionNames = validateOptionNames;
        }

        public void setValidateLocalConfiguration(boolean validateLocalConfiguration) {
            this.validateLocalConfiguration = validateLocalConfiguration;
        }

        public void setValidateOutputConnection(boolean validateOutputConnection) {
            this.validateOutputConnection = validateOutputConnection;
        }

        public void setValidatePlaceholder(boolean validatePlaceholder) {
            this.validatePlaceholder = validatePlaceholder;
        }

        public void setValidateSvg(boolean validateSvg) {
            this.validateSvg = validateSvg;
        }

        public void setValidateNoFinalOption(boolean validateNoFinalOption) {
            this.validateNoFinalOption = validateNoFinalOption;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public void setValidateExceptions(boolean validateExceptions) {
            this.validateExceptions = validateExceptions;
        }

        public void setFailOnValidateExceptions(boolean failOnValidateExceptions) {
            this.failOnValidateExceptions = failOnValidateExceptions;
        }

        public void setValidateRecord(boolean validateRecord) {
            this.validateRecord = validateRecord;
        }

        public void setValidateSchema(boolean validateSchema) {
            this.validateSchema = validateSchema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isValidateFamily() != other.isValidateFamily()) {
                return false;
            }
            if (this.isValidateSerializable() != other.isValidateSerializable()) {
                return false;
            }
            if (this.isValidateInternationalization() != other.isValidateInternationalization()) {
                return false;
            }
            if (this.isValidateHttpClient() != other.isValidateHttpClient()) {
                return false;
            }
            if (this.isValidateModel() != other.isValidateModel()) {
                return false;
            }
            if (this.isValidateMetadata() != other.isValidateMetadata()) {
                return false;
            }
            if (this.isValidateComponent() != other.isValidateComponent()) {
                return false;
            }
            if (this.isValidateDataStore() != other.isValidateDataStore()) {
                return false;
            }
            if (this.isValidateDataSet() != other.isValidateDataSet()) {
                return false;
            }
            if (this.isValidateActions() != other.isValidateActions()) {
                return false;
            }
            if (this.isValidateDocumentation() != other.isValidateDocumentation()) {
                return false;
            }
            if (this.isValidateWording() != other.isValidateWording()) {
                return false;
            }
            if (this.isValidateLayout() != other.isValidateLayout()) {
                return false;
            }
            if (this.isValidateOptionNames() != other.isValidateOptionNames()) {
                return false;
            }
            if (this.isValidateLocalConfiguration() != other.isValidateLocalConfiguration()) {
                return false;
            }
            if (this.isValidateOutputConnection() != other.isValidateOutputConnection()) {
                return false;
            }
            if (this.isValidatePlaceholder() != other.isValidatePlaceholder()) {
                return false;
            }
            if (this.isValidateSvg() != other.isValidateSvg()) {
                return false;
            }
            if (this.isValidateNoFinalOption() != other.isValidateNoFinalOption()) {
                return false;
            }
            if (this.isValidateExceptions() != other.isValidateExceptions()) {
                return false;
            }
            if (this.isFailOnValidateExceptions() != other.isFailOnValidateExceptions()) {
                return false;
            }
            if (this.isValidateRecord() != other.isValidateRecord()) {
                return false;
            }
            if (this.isValidateSchema() != other.isValidateSchema()) {
                return false;
            }
            String this$pluginId = this.getPluginId();
            String other$pluginId = other.getPluginId();
            return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValidateFamily() ? 79 : 97);
            result = result * 59 + (this.isValidateSerializable() ? 79 : 97);
            result = result * 59 + (this.isValidateInternationalization() ? 79 : 97);
            result = result * 59 + (this.isValidateHttpClient() ? 79 : 97);
            result = result * 59 + (this.isValidateModel() ? 79 : 97);
            result = result * 59 + (this.isValidateMetadata() ? 79 : 97);
            result = result * 59 + (this.isValidateComponent() ? 79 : 97);
            result = result * 59 + (this.isValidateDataStore() ? 79 : 97);
            result = result * 59 + (this.isValidateDataSet() ? 79 : 97);
            result = result * 59 + (this.isValidateActions() ? 79 : 97);
            result = result * 59 + (this.isValidateDocumentation() ? 79 : 97);
            result = result * 59 + (this.isValidateWording() ? 79 : 97);
            result = result * 59 + (this.isValidateLayout() ? 79 : 97);
            result = result * 59 + (this.isValidateOptionNames() ? 79 : 97);
            result = result * 59 + (this.isValidateLocalConfiguration() ? 79 : 97);
            result = result * 59 + (this.isValidateOutputConnection() ? 79 : 97);
            result = result * 59 + (this.isValidatePlaceholder() ? 79 : 97);
            result = result * 59 + (this.isValidateSvg() ? 79 : 97);
            result = result * 59 + (this.isValidateNoFinalOption() ? 79 : 97);
            result = result * 59 + (this.isValidateExceptions() ? 79 : 97);
            result = result * 59 + (this.isFailOnValidateExceptions() ? 79 : 97);
            result = result * 59 + (this.isValidateRecord() ? 79 : 97);
            result = result * 59 + (this.isValidateSchema() ? 79 : 97);
            String $pluginId = this.getPluginId();
            result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentValidator.Configuration(validateFamily=" + this.isValidateFamily() + ", validateSerializable=" + this.isValidateSerializable() + ", validateInternationalization=" + this.isValidateInternationalization() + ", validateHttpClient=" + this.isValidateHttpClient() + ", validateModel=" + this.isValidateModel() + ", validateMetadata=" + this.isValidateMetadata() + ", validateComponent=" + this.isValidateComponent() + ", validateDataStore=" + this.isValidateDataStore() + ", validateDataSet=" + this.isValidateDataSet() + ", validateActions=" + this.isValidateActions() + ", validateDocumentation=" + this.isValidateDocumentation() + ", validateWording=" + this.isValidateWording() + ", validateLayout=" + this.isValidateLayout() + ", validateOptionNames=" + this.isValidateOptionNames() + ", validateLocalConfiguration=" + this.isValidateLocalConfiguration() + ", validateOutputConnection=" + this.isValidateOutputConnection() + ", validatePlaceholder=" + this.isValidatePlaceholder() + ", validateSvg=" + this.isValidateSvg() + ", validateNoFinalOption=" + this.isValidateNoFinalOption() + ", pluginId=" + this.getPluginId() + ", validateExceptions=" + this.isValidateExceptions() + ", failOnValidateExceptions=" + this.isFailOnValidateExceptions() + ", validateRecord=" + this.isValidateRecord() + ", validateSchema=" + this.isValidateSchema() + ")";
        }
    }
}

