/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.talend.sdk.component.api.service.factory.ObjectFactory;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class ObjectFactoryImpl
implements ObjectFactory,
Serializable {
    private final String plugin;
    private final PropertyEditorRegistry registry;

    public ObjectFactory.ObjectFactoryInstance createInstance(String type) {
        ObjectRecipe recipe = new ObjectRecipe(type);
        recipe.setRegistry(this.registry);
        return new ObjectFactoryInstanceImpl(recipe);
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, ObjectFactory.class.getName());
    }

    public ObjectFactoryImpl(String plugin, PropertyEditorRegistry registry) {
        this.plugin = plugin;
        this.registry = registry;
    }

    private static class ObjectFactoryInstanceImpl
    implements ObjectFactory.ObjectFactoryInstance {
        private final ObjectRecipe recipe;

        public ObjectFactory.ObjectFactoryInstance withFieldInjection() {
            this.recipe.allow(Option.FIELD_INJECTION);
            this.recipe.allow(Option.PRIVATE_PROPERTIES);
            return this;
        }

        public ObjectFactory.ObjectFactoryInstance ignoreUnknownProperties() {
            this.recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            return this;
        }

        public ObjectFactory.ObjectFactoryInstance withProperties(Map<String, ?> map) {
            this.recipe.setAllProperties(map);
            return this;
        }

        public <T> T create(Class<T> aClass) {
            if (this.recipe.getProperties().keySet().stream().map(it -> it.toLowerCase(Locale.ROOT)).collect(Collectors.toSet()).size() == this.recipe.getProperties().size()) {
                this.recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            }
            try {
                return aClass.cast(this.recipe.create(Thread.currentThread().getContextClassLoader()));
            }
            catch (RuntimeException re) {
                throw new IllegalArgumentException(re);
            }
        }

        public ObjectFactoryInstanceImpl(ObjectRecipe recipe) {
            this.recipe = recipe;
        }
    }
}

