/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;

public class Defaults {
    private static final Constructor<MethodHandles.Lookup> LOOKUP;
    private static final Method PRIVATE_LOOKUP;

    public static MethodHandles.Lookup of(Class<?> declaringClass) {
        try {
            if (PRIVATE_LOOKUP != null) {
                return (MethodHandles.Lookup)MethodHandles.Lookup.class.cast(PRIVATE_LOOKUP.invoke(null, declaringClass, MethodHandles.lookup()));
            }
            return LOOKUP.newInstance(declaringClass, 2).in(declaringClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException(e);
        }
    }

    private Defaults() {
    }

    static {
        Constructor lookup = null;
        Method privateLookup = null;
        try {
            privateLookup = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                if (!lookup.isAccessible()) {
                    lookup.setAccessible(true);
                }
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Incompatible JVM", e);
            }
        }
        PRIVATE_LOOKUP = privateLookup;
        LOOKUP = lookup;
    }
}

