/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.core.JsonLongImpl;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;

public class RecordConverters
implements Serializable {
    private static final ZoneId UTC = ZoneId.of("UTC");

    public <T> T mapNumber(Class<T> expected, Number from) {
        if (expected == Double.class || expected == Double.TYPE) {
            return expected.cast(from.doubleValue());
        }
        if (expected == Float.class || expected == Float.TYPE) {
            return expected.cast(Float.valueOf(from.floatValue()));
        }
        if (expected == Integer.class || expected == Integer.TYPE) {
            return expected.cast(from.intValue());
        }
        if (expected == Long.class || expected == Long.TYPE) {
            return expected.cast(from.longValue());
        }
        throw new IllegalArgumentException("Can't convert " + from + " to " + expected);
    }

    public <T> Record toRecord(T data, Supplier<Jsonb> jsonbProvider, Supplier<RecordBuilderFactory> recordBuilderProvider) {
        if (Record.class.isInstance(data)) {
            return (Record)Record.class.cast(data);
        }
        if (JsonObject.class.isInstance(data)) {
            return this.json2Record(recordBuilderProvider.get(), (JsonObject)JsonObject.class.cast(data));
        }
        Jsonb jsonb = jsonbProvider.get();
        return this.json2Record(recordBuilderProvider.get(), (JsonObject)jsonb.fromJson(jsonb.toJson(data), JsonObject.class));
    }

    private Record json2Record(RecordBuilderFactory factory, JsonObject object) {
        Record.Builder builder = factory.newRecordBuilder();
        object.forEach((key, value) -> {
            switch (value.getValueType()) {
                case ARRAY: {
                    List<Object> items = value.asJsonArray().stream().map(it -> this.mapJson(factory, (JsonValue)it)).collect(Collectors.toList());
                    builder.withArray(factory.newEntryBuilder().withName(key).withType(Schema.Type.ARRAY).withElementSchema(this.getArrayElementSchema(factory, items)).build(), items);
                    break;
                }
                case OBJECT: {
                    Record record = this.json2Record(factory, value.asJsonObject());
                    builder.withRecord(factory.newEntryBuilder().withName(key).withType(Schema.Type.RECORD).withElementSchema(record.getSchema()).build(), record);
                    break;
                }
                case TRUE: 
                case FALSE: {
                    builder.withBoolean(key, JsonValue.TRUE.equals(value));
                    break;
                }
                case STRING: {
                    builder.withString(key, ((JsonString)JsonString.class.cast(value)).getString());
                    break;
                }
                case NUMBER: {
                    JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                    builder.withDouble(key, number.doubleValue());
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported value type: " + value);
                }
            }
        });
        return builder.build();
    }

    private Schema getArrayElementSchema(RecordBuilderFactory factory, List<Object> items) {
        if (items.isEmpty()) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        Schema firstSchema = this.toSchema(factory, items.iterator().next());
        switch (firstSchema.getType()) {
            case RECORD: {
                return items.stream().map(it -> this.toSchema(factory, it)).reduce(null, (s1, s2) -> {
                    Set names2;
                    if (s1 == null) {
                        return s2;
                    }
                    if (s2 == null) {
                        return s1;
                    }
                    List entries1 = s1.getEntries();
                    List entries2 = s2.getEntries();
                    Set names1 = entries1.stream().map(Schema.Entry::getName).collect(Collectors.toSet());
                    if (!names1.equals(names2 = entries2.stream().map(Schema.Entry::getName).collect(Collectors.toSet()))) {
                        Schema.Builder builder = factory.newSchemaBuilder(Schema.Type.RECORD);
                        entries1.forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        names2.removeAll(names1);
                        entries2.stream().filter(it -> names2.contains(it.getName())).forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                        return builder.build();
                    }
                    return s1;
                });
            }
        }
        return firstSchema;
    }

    private Object mapJson(RecordBuilderFactory factory, JsonValue it) {
        if (JsonObject.class.isInstance(it)) {
            return this.json2Record(factory, (JsonObject)JsonObject.class.cast(it));
        }
        if (JsonArray.class.isInstance(it)) {
            return ((JsonArray)JsonArray.class.cast(it)).stream().map(i -> this.mapJson(factory, (JsonValue)i)).collect(Collectors.toList());
        }
        if (JsonString.class.isInstance(it)) {
            return ((JsonString)JsonString.class.cast(it)).getString();
        }
        if (JsonNumber.class.isInstance(it)) {
            return ((JsonNumber)JsonNumber.class.cast(it)).numberValue();
        }
        if (JsonValue.FALSE.equals(it)) {
            return false;
        }
        if (JsonValue.TRUE.equals(it)) {
            return true;
        }
        if (JsonValue.NULL.equals(it)) {
            return null;
        }
        return it;
    }

    private Schema toSchema(RecordBuilderFactory factory, Object next) {
        if (String.class.isInstance(next) || JsonString.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.STRING).build();
        }
        if (Integer.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.INT).build();
        }
        if (Long.class.isInstance(next) || JsonLongImpl.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.LONG).build();
        }
        if (Float.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.FLOAT).build();
        }
        if (Double.class.isInstance(next) || JsonNumber.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DOUBLE).build();
        }
        if (Boolean.class.isInstance(next) || JsonValue.TRUE.equals(next) || JsonValue.FALSE.equals(next)) {
            return factory.newSchemaBuilder(Schema.Type.BOOLEAN).build();
        }
        if (Date.class.isInstance(next) || ZonedDateTime.class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.DATETIME).build();
        }
        if (byte[].class.isInstance(next)) {
            return factory.newSchemaBuilder(Schema.Type.BYTES).build();
        }
        if (Collection.class.isInstance(next) || JsonArray.class.isInstance(next)) {
            Collection collection = (Collection)Collection.class.cast(next);
            if (collection.isEmpty()) {
                return factory.newSchemaBuilder(Schema.Type.STRING).build();
            }
            return factory.newSchemaBuilder(Schema.Type.ARRAY).withElementSchema(this.toSchema(factory, collection.iterator().next())).build();
        }
        if (Record.class.isInstance(next)) {
            return ((Record)Record.class.cast(next)).getSchema();
        }
        throw new IllegalArgumentException("unsupported type for " + next);
    }

    public Object toType(Object data, Class<?> parameterType, Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Supplier<Jsonb> jsonbProvider) {
        String inputAsJson;
        if (parameterType.isInstance(data)) {
            return data;
        }
        Jsonb jsonb = jsonbProvider.get();
        if (JsonObject.class.isInstance(data)) {
            if (JsonObject.class == parameterType) {
                return data;
            }
            inputAsJson = ((JsonObject)JsonObject.class.cast(data)).toString();
        } else if (Record.class.isInstance(data)) {
            JsonObject asJson = this.toJson(factorySupplier, providerSupplier, (Record)Record.class.cast(data));
            if (JsonObject.class == parameterType) {
                return asJson;
            }
            inputAsJson = asJson.toString();
        } else {
            inputAsJson = jsonb.toJson(data);
        }
        if (parameterType == JsonObject.class) {
            return jsonb.fromJson(inputAsJson, parameterType);
        }
        return jsonb.fromJson(inputAsJson, parameterType);
    }

    private JsonObject toJson(Supplier<JsonBuilderFactory> factorySupplier, Supplier<JsonProvider> providerSupplier, Record record) {
        return this.buildRecord(factorySupplier.get(), providerSupplier, record).build();
    }

    private JsonObjectBuilder buildRecord(JsonBuilderFactory factory, Supplier<JsonProvider> providerSupplier, Record record) {
        Schema schema = record.getSchema();
        JsonObjectBuilder builder = factory.createObjectBuilder();
        schema.getEntries().forEach(entry -> {
            String name = entry.getName();
            switch (entry.getType()) {
                case STRING: {
                    String value = (String)record.get(String.class, name);
                    if (value == null) break;
                    builder.add(name, value);
                    break;
                }
                case INT: {
                    Integer value = (Integer)record.get(Integer.class, name);
                    if (value == null) break;
                    builder.add(name, value.intValue());
                    break;
                }
                case LONG: {
                    Long value = (Long)record.get(Long.class, name);
                    if (value == null) break;
                    builder.add(name, value.longValue());
                    break;
                }
                case FLOAT: {
                    Float value = (Float)record.get(Float.class, name);
                    if (value == null) break;
                    builder.add(name, (double)value.floatValue());
                    break;
                }
                case DOUBLE: {
                    Double value = (Double)record.get(Double.class, name);
                    if (value == null) break;
                    builder.add(name, value.doubleValue());
                    break;
                }
                case BOOLEAN: {
                    Boolean value = (Boolean)record.get(Boolean.class, name);
                    if (value == null) break;
                    builder.add(name, value.booleanValue());
                    break;
                }
                case BYTES: {
                    byte[] value = (byte[])record.get(byte[].class, name);
                    if (value == null) break;
                    builder.add(name, Base64.getEncoder().encodeToString(value));
                    break;
                }
                case DATETIME: {
                    ZonedDateTime value = (ZonedDateTime)record.get(ZonedDateTime.class, name);
                    if (value == null) break;
                    builder.add(name, value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                    break;
                }
                case RECORD: {
                    Record value = (Record)record.get(Record.class, name);
                    if (value == null) break;
                    builder.add(name, this.buildRecord(factory, providerSupplier, value));
                    break;
                }
                case ARRAY: {
                    Collection collection = (Collection)record.get(Collection.class, name);
                    if (collection == null) break;
                    if (collection.isEmpty()) {
                        builder.add(name, (JsonValue)factory.createArrayBuilder().build());
                        break;
                    }
                    Object item = collection.iterator().next();
                    if (String.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((String)String.class.cast(v)), collection));
                        break;
                    }
                    if (Double.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Double)Double.class.cast(v)).doubleValue()), collection));
                        break;
                    }
                    if (Float.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue((double)((Float)Float.class.cast(v)).floatValue()), collection));
                        break;
                    }
                    if (Double.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Double)Double.class.cast(v)).doubleValue()), collection));
                        break;
                    }
                    if (Integer.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Integer)Integer.class.cast(v)).intValue()), collection));
                        break;
                    }
                    if (Long.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Long)Long.class.cast(v)).longValue()), collection));
                        break;
                    }
                    if (Boolean.class.isInstance(item)) {
                        builder.add(name, (JsonValue)this.toArray(factory, v -> (Boolean)Boolean.class.cast(v) != false ? JsonValue.TRUE : JsonValue.FALSE, collection));
                        break;
                    }
                    if (ZonedDateTime.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((ZonedDateTime)ZonedDateTime.class.cast(v)).toInstant().toEpochMilli()), collection));
                        break;
                    }
                    if (Date.class.isInstance(item)) {
                        JsonProvider jsonProvider = (JsonProvider)providerSupplier.get();
                        builder.add(name, (JsonValue)this.toArray(factory, v -> jsonProvider.createValue(((Date)Date.class.cast(v)).getTime()), collection));
                        break;
                    }
                    if (!Record.class.isInstance(item)) break;
                    builder.add(name, (JsonValue)this.toArray(factory, arg_0 -> this.lambda$null$15(factory, (Supplier)providerSupplier, arg_0), collection));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + entry.getType() + " for '" + name + "'");
                }
            }
        });
        return builder;
    }

    private JsonArray toArray(JsonBuilderFactory factory, Function<Object, JsonValue> valueFactory, Collection<?> collection) {
        Collector<JsonValue, JsonArrayBuilder, JsonArray> collector = Collector.of(() -> ((JsonBuilderFactory)factory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
        return collection.stream().map(valueFactory).collect(collector);
    }

    public <T> T coerce(Class<T> expectedType, Object value, String name) {
        if (value == null) {
            return null;
        }
        if (Long.class.isInstance(value) && expectedType != Long.class) {
            if (expectedType == ZonedDateTime.class) {
                long epochMilli = ((Number)Number.class.cast(value)).longValue();
                if (epochMilli == -1L) {
                    return null;
                }
                return expectedType.cast(ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), UTC));
            }
            if (expectedType == Date.class) {
                return expectedType.cast(new Date(((Number)Number.class.cast(value)).longValue()));
            }
        }
        if (!expectedType.isInstance(value)) {
            if (Number.class.isInstance(value) && Number.class.isAssignableFrom(expectedType)) {
                return this.mapNumber(expectedType, (Number)Number.class.cast(value));
            }
            if (String.class.isInstance(value)) {
                if (ZonedDateTime.class == expectedType) {
                    return expectedType.cast(ZonedDateTime.parse(String.valueOf(value)));
                }
                if (byte[].class == expectedType) {
                    return expectedType.cast(Base64.getDecoder().decode(String.valueOf(value)));
                }
            }
            throw new IllegalArgumentException(name + " can't be converted to " + expectedType);
        }
        return expectedType.cast(value);
    }

    private /* synthetic */ JsonValue lambda$null$15(JsonBuilderFactory factory, Supplier providerSupplier, Object v) {
        return this.buildRecord(factory, providerSupplier, (Record)Record.class.cast(v)).build();
    }
}

