/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demos.orders;

import java.io.StringReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.annotations.Transformer;
import org.switchyard.quickstarts.demos.orders.Order;
import org.switchyard.quickstarts.demos.orders.OrderAck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Transformers {
    private static final String ORDER_ID = "orderId";
    private static final String ITEM_ID = "itemId";
    private static final String QUANTITY = "quantity";

    @Transformer(from="{urn:switchyard-quickstart-demo:orders:1.0}submitOrder")
    public Order transform(Element from) {
        return new Order().setOrderId(this.getElementValue(from, ORDER_ID)).setItemId(this.getElementValue(from, ITEM_ID)).setQuantity(Integer.valueOf(this.getElementValue(from, QUANTITY)).intValue());
    }

    @Transformer(to="{urn:switchyard-quickstart-demo:orders:1.0}submitOrderResponse")
    public Element transform(OrderAck orderAck) {
        StringBuffer ackXml = new StringBuffer().append("<orders:submitOrderResponse xmlns:orders=\"urn:switchyard-quickstart-demo:orders:1.0\">").append("<orderAck>").append("<orderId>" + orderAck.getOrderId() + "</orderId>").append("<accepted>" + orderAck.isAccepted() + "</accepted>").append("<status>" + orderAck.getStatus() + "</status>").append("</orderAck>").append("</orders:submitOrderResponse>");
        return this.toElement(ackXml.toString());
    }

    private String getElementValue(Element parent, String elementName) {
        String value = null;
        NodeList nodes = parent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            value = nodes.item(0).getChildNodes().item(0).getNodeValue();
        }
        return value;
    }

    private Element toElement(String xml) {
        DOMResult dom = new DOMResult();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(xml)), dom);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ((Document)dom.getNode()).getDocumentElement();
    }
}

