/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db.table;

import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ssssssss.magicapi.core.context.RequestContext;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.core.model.Attributes;
import org.ssssssss.magicapi.modules.db.BoundSql;
import org.ssssssss.magicapi.modules.db.SQLModule;
import org.ssssssss.magicapi.modules.db.inteceptor.NamedTableInterceptor;
import org.ssssssss.magicapi.modules.db.model.Page;
import org.ssssssss.magicapi.modules.db.model.SqlMode;
import org.ssssssss.magicapi.modules.db.table.Where;
import org.ssssssss.script.annotation.Comment;
import org.ssssssss.script.runtime.RuntimeContext;

public class NamedTable
extends Attributes<Object> {
    String tableName;
    SQLModule sqlModule;
    String primary;
    String logicDeleteColumn;
    Object logicDeleteValue;
    Map<String, Object> columns = new HashMap<String, Object>();
    List<String> fields = new ArrayList<String>();
    List<String> groups = new ArrayList<String>();
    List<String> orders = new ArrayList<String>();
    Set<String> excludeColumns = new HashSet<String>();
    Function<String, String> rowMapColumnMapper;
    Object defaultPrimaryValue;
    boolean useLogic = false;
    boolean withBlank = false;
    List<NamedTableInterceptor> namedTableInterceptors;
    Where where = new Where(this);

    public NamedTable(String tableName, SQLModule sqlModule, Function<String, String> rowMapColumnMapper, List<NamedTableInterceptor> namedTableInterceptors) {
        this.tableName = tableName;
        this.sqlModule = sqlModule;
        this.rowMapColumnMapper = rowMapColumnMapper;
        this.namedTableInterceptors = namedTableInterceptors;
        this.logicDeleteColumn = sqlModule.getLogicDeleteColumn();
        String deleteValue = sqlModule.getLogicDeleteValue();
        this.logicDeleteValue = deleteValue;
        if (deleteValue != null) {
            boolean isString;
            boolean bl = isString = deleteValue.startsWith("'") || deleteValue.startsWith("\"");
            if (isString && deleteValue.length() > 2) {
                this.logicDeleteValue = deleteValue.substring(1, deleteValue.length() - 1);
            } else {
                try {
                    this.logicDeleteValue = Integer.parseInt(deleteValue);
                }
                catch (NumberFormatException e) {
                    this.logicDeleteValue = deleteValue;
                }
            }
        }
    }

    private NamedTable() {
    }

    @Comment(value="\u514b\u9686")
    public NamedTable clone() {
        NamedTable namedTable = new NamedTable();
        namedTable.tableName = this.tableName;
        namedTable.sqlModule = this.sqlModule;
        namedTable.primary = this.primary;
        namedTable.logicDeleteValue = this.logicDeleteValue;
        namedTable.logicDeleteColumn = this.logicDeleteColumn;
        namedTable.columns = new HashMap<String, Object>(this.columns);
        namedTable.fields = new ArrayList<String>(this.fields);
        namedTable.groups = new ArrayList<String>(this.groups);
        namedTable.orders = new ArrayList<String>(this.orders);
        namedTable.excludeColumns = new HashSet<String>(this.excludeColumns);
        namedTable.rowMapColumnMapper = this.rowMapColumnMapper;
        namedTable.defaultPrimaryValue = this.defaultPrimaryValue;
        namedTable.useLogic = this.useLogic;
        namedTable.withBlank = this.withBlank;
        namedTable.where = this.where == null ? null : this.where.clone();
        namedTable.namedTableInterceptors = this.namedTableInterceptors;
        namedTable.properties = this.properties;
        return namedTable;
    }

    @Comment(value="\u4f7f\u7528\u903b\u8f91\u5220\u9664")
    public NamedTable logic() {
        this.useLogic = true;
        return this;
    }

    @Comment(value="\u66f4\u65b0\u7a7a\u503c")
    public NamedTable withBlank() {
        this.withBlank = true;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u4e3b\u952e\u540d\uff0cupdate\u65f6\u4f7f\u7528")
    public NamedTable primary(@Comment(name="primary", value="\u4e3b\u952e\u5217") String primary) {
        this.primary = this.rowMapColumnMapper.apply(primary);
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u4e3b\u952e\u540d\uff0c\u5e76\u8bbe\u7f6e\u9ed8\u8ba4\u4e3b\u952e\u503c(\u4e3b\u8981\u7528\u4e8einsert)")
    public NamedTable primary(@Comment(name="primary", value="\u4e3b\u952e\u5217") String primary, @Comment(name="defaultPrimaryValue", value="\u9ed8\u8ba4\u503c") Serializable defaultPrimaryValue) {
        this.primary = this.rowMapColumnMapper.apply(primary);
        this.defaultPrimaryValue = defaultPrimaryValue;
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u4e3b\u952e\u540d\uff0c\u5e76\u8bbe\u7f6e\u9ed8\u8ba4\u4e3b\u952e\u503c(\u4e3b\u8981\u7528\u4e8einsert)")
    public NamedTable primary(@Comment(name="primary", value="\u4e3b\u952e\u5217") String primary, @Comment(name="defaultPrimaryValue", value="\u9ed8\u8ba4\u503c") Supplier<Object> defaultPrimaryValue) {
        this.primary = this.rowMapColumnMapper.apply(primary);
        this.defaultPrimaryValue = defaultPrimaryValue;
        return this;
    }

    @Comment(value="\u62fc\u63a5where")
    public Where where() {
        return this.where;
    }

    @Comment(value="\u8bbe\u7f6e\u5355\u5217\u7684\u503c")
    public NamedTable column(@Comment(name="property", value="\u5217\u540d") String property, @Comment(name="value", value="\u503c") Object value) {
        this.columns.put(this.rowMapColumnMapper.apply(property), value);
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`columns('a','b','c')`")
    public NamedTable columns(String ... properties) {
        if (properties != null) {
            for (String property : properties) {
                this.column(property);
            }
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8981\u6392\u9664\u7684\u5217")
    public NamedTable exclude(@Comment(name="property", value="\u6392\u9664\u7684\u5217") String property) {
        if (property != null) {
            this.excludeColumns.add(this.rowMapColumnMapper.apply(property));
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8981\u6392\u9664\u7684\u5217")
    public NamedTable excludes(String ... properties) {
        if (this.columns != null) {
            this.excludeColumns.addAll(Arrays.stream(properties).map(this.rowMapColumnMapper).collect(Collectors.toList()));
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u8981\u6392\u9664\u7684\u5217")
    public NamedTable excludes(@Comment(name="properties", value="\u6392\u9664\u7684\u5217") List<String> properties) {
        if (this.columns != null) {
            this.excludeColumns.addAll(properties.stream().map(this.rowMapColumnMapper).collect(Collectors.toList()));
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`columns(['a','b','c'])`")
    public NamedTable columns(@Comment(name="properties", value="\u67e5\u8be2\u7684\u5217") Collection<String> properties) {
        if (properties != null) {
            properties.stream().filter(StringUtils::isNotBlank).map(this.rowMapColumnMapper).forEach(this.fields::add);
        }
        return this;
    }

    @Comment(value="\u8bbe\u7f6e\u67e5\u8be2\u7684\u5217\uff0c\u5982`column('a')`")
    public NamedTable column(@Comment(name="property", value="\u67e5\u8be2\u7684\u5217") String property) {
        if (StringUtils.isNotBlank((CharSequence)property)) {
            this.fields.add(this.rowMapColumnMapper.apply(property));
        }
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc/desc`")
    public NamedTable orderBy(@Comment(name="property", value="\u8981\u6392\u5e8f\u7684\u5217") String property, @Comment(name="sort", value="`asc`\u6216`desc`") String sort) {
        this.orders.add(this.rowMapColumnMapper.apply(property) + " " + sort);
        return this;
    }

    @Comment(value="\u62fc\u63a5`order by xxx asc`")
    public NamedTable orderBy(@Comment(name="property", value="\u8981\u6392\u5e8f\u7684\u5217") String property) {
        return this.orderBy(property, "asc");
    }

    @Comment(value="\u62fc\u63a5`order by xxx desc`")
    public NamedTable orderByDesc(@Comment(name="property", value="\u8981\u6392\u5e8f\u7684\u5217") String property) {
        return this.orderBy(property, "desc");
    }

    @Comment(value="\u62fc\u63a5`group by`")
    public NamedTable groupBy(String ... properties) {
        this.groups.addAll(Arrays.stream(properties).map(this.rowMapColumnMapper).collect(Collectors.toList()));
        return this;
    }

    @Comment(value="\u6267\u884c\u63d2\u5165,\u8fd4\u56de\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext) {
        return this.insert(runtimeContext, null);
    }

    @Comment(value="\u6267\u884c\u63d2\u5165,\u8fd4\u56de\u4e3b\u952e")
    public Object insert(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        if (data != null) {
            data.forEach((key, value) -> this.columns.put(this.rowMapColumnMapper.apply((String)key), value));
        }
        if (this.defaultPrimaryValue != null && StringUtils.isBlank((CharSequence)Objects.toString(this.columns.getOrDefault(this.primary, "")))) {
            if (this.defaultPrimaryValue instanceof Supplier) {
                this.columns.put(this.primary, ((Supplier)this.defaultPrimaryValue).get());
            } else {
                this.columns.put(this.primary, this.defaultPrimaryValue);
            }
        }
        this.preHandle(SqlMode.INSERT);
        Collection<Map.Entry<String, Object>> entries = this.filterNotBlanks();
        if (entries.isEmpty()) {
            throw new MagicAPIException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append(this.tableName);
        builder.append("(");
        builder.append(StringUtils.join((Object[])entries.stream().map(Map.Entry::getKey).toArray(), (String)","));
        builder.append(") values (");
        builder.append(StringUtils.join(Collections.nCopies(entries.size(), "?"), (String)","));
        builder.append(")");
        Object value2 = this.sqlModule.insert(new BoundSql(runtimeContext, builder.toString(), entries.stream().map(Map.Entry::getValue).collect(Collectors.toList()), this.sqlModule), this.primary);
        if (value2 == null && StringUtils.isNotBlank((CharSequence)this.primary)) {
            return this.columns.get(this.primary);
        }
        return value2;
    }

    @Comment(value="\u6267\u884cdelete\u8bed\u53e5")
    public int delete(RuntimeContext runtimeContext) {
        this.preHandle(SqlMode.DELETE);
        if (this.useLogic) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(this.logicDeleteColumn, this.logicDeleteValue);
            return this.update(runtimeContext, dataMap);
        }
        if (this.where.isEmpty()) {
            throw new MagicAPIException("delete\u8bed\u53e5\u4e0d\u80fd\u6ca1\u6709\u6761\u4ef6");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("delete from ");
        builder.append(this.tableName);
        builder.append(this.where.getSql());
        return this.sqlModule.update(new BoundSql(runtimeContext, builder.toString(), this.where.getParams(), this.sqlModule));
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext) {
        return this.save(runtimeContext, null, false);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data, @Comment(name="beforeQuery", value="\u662f\u5426\u6839\u636eid\u67e5\u8be2\u6709\u6ca1\u6709\u6570\u636e") boolean beforeQuery) {
        String primaryValue;
        if (StringUtils.isBlank((CharSequence)this.primary)) {
            throw new MagicAPIException("\u8bf7\u8bbe\u7f6e\u4e3b\u952e");
        }
        if (data != null) {
            data.forEach((key, value) -> this.columns.put(this.rowMapColumnMapper.apply((String)key), value));
        }
        if (StringUtils.isBlank((CharSequence)(primaryValue = Objects.toString(this.columns.get(this.primary), ""))) && data != null) {
            primaryValue = Objects.toString(data.get(this.primary), "");
        }
        if (beforeQuery) {
            if (StringUtils.isNotBlank((CharSequence)primaryValue)) {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(primaryValue);
                Integer count = this.sqlModule.selectInt(new BoundSql(runtimeContext, "select count(*) count from " + this.tableName + " where " + this.primary + " = ?", params, this.sqlModule));
                if (count == 0) {
                    return this.insert(runtimeContext, data);
                }
                return this.update(runtimeContext, data);
            }
            return this.insert(runtimeContext, data);
        }
        if (StringUtils.isNotBlank((CharSequence)primaryValue)) {
            return this.update(runtimeContext, data);
        }
        return this.insert(runtimeContext, data);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="beforeQuery", value="\u662f\u5426\u6839\u636eid\u67e5\u8be2\u6709\u6ca1\u6709\u6570\u636e") boolean beforeQuery) {
        return this.save(runtimeContext, null, beforeQuery);
    }

    @Comment(value="\u4fdd\u5b58\u5230\u8868\u4e2d\uff0c\u5f53\u4e3b\u952e\u6709\u503c\u65f6\u5219\u4fee\u6539\uff0c\u5426\u5219\u63d2\u5165")
    public Object save(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.save(runtimeContext, data, false);
    }

    @Comment(value="\u6279\u91cf\u63d2\u5165")
    public int batchInsert(@Comment(name="collection", value="\u5404\u9879\u5217\u548c\u503c") Collection<Map<String, Object>> collection, @Comment(value="batchSize") int batchSize) {
        Set keys = collection.stream().flatMap(it -> it.keySet().stream()).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            throw new MagicAPIException("\u8981\u63d2\u5165\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append(this.tableName);
        builder.append("(");
        builder.append(StringUtils.join((Iterable)keys.stream().map(this.rowMapColumnMapper).collect(Collectors.toList()), (String)","));
        builder.append(") values (");
        builder.append(StringUtils.join(Collections.nCopies(keys.size(), "?"), (String)","));
        builder.append(")");
        return this.sqlModule.batchUpdate(builder.toString(), batchSize, collection.stream().map(it -> keys.stream().map(it::get).toArray()).collect(Collectors.toList()));
    }

    @Comment(value="\u6279\u91cf\u63d2\u5165")
    public int batchInsert(@Comment(name="collection", value="\u5404\u9879\u5217\u548c\u503c") Collection<Map<String, Object>> collection) {
        return this.batchInsert(collection, 100);
    }

    @Comment(value="\u6267\u884c`select`\u67e5\u8be2")
    public List<Map<String, Object>> select(RuntimeContext runtimeContext) {
        this.preHandle(SqlMode.SELECT);
        return this.sqlModule.select(this.buildSelect(runtimeContext));
    }

    @Comment(value="\u6267\u884c`selectOne`\u67e5\u8be2")
    public Map<String, Object> selectOne(RuntimeContext runtimeContext) {
        this.preHandle(SqlMode.SELECT_ONE);
        return this.sqlModule.selectOne(this.buildSelect(runtimeContext));
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2")
    public Object page(RuntimeContext runtimeContext) {
        this.preHandle(SqlMode.PAGE);
        return this.sqlModule.page(this.buildSelect(runtimeContext));
    }

    @Comment(value="\u6267\u884c\u5206\u9875\u67e5\u8be2\uff0c\u5206\u9875\u6761\u4ef6\u624b\u52a8\u4f20\u5165")
    public Object page(RuntimeContext runtimeContext, @Comment(name="limit", value="\u9650\u5236\u6761\u6570") long limit, @Comment(name="offset", value="\u8df3\u8fc7\u6761\u6570") long offset) {
        this.preHandle(SqlMode.PAGE);
        return this.sqlModule.page(this.buildSelect(runtimeContext), new Page(limit, offset));
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext) {
        return this.update(runtimeContext, null);
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data, @Comment(name="isUpdateBlank", value="\u662f\u5426\u66f4\u65b0\u7a7a\u503c\u5b57\u6bb5") boolean isUpdateBlank) {
        if (null != data) {
            data.forEach((key, value) -> this.columns.put(this.rowMapColumnMapper.apply((String)key), value));
        }
        this.preHandle(SqlMode.UPDATE);
        Object primaryValue = null;
        if (StringUtils.isNotBlank((CharSequence)this.primary)) {
            primaryValue = this.columns.remove(this.primary);
        }
        this.withBlank = isUpdateBlank;
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(this.filterNotBlanks());
        if (entries.isEmpty()) {
            throw new MagicAPIException("\u8981\u4fee\u6539\u7684\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("update ");
        builder.append(this.tableName);
        builder.append(" set ");
        ArrayList<Object> params = new ArrayList<Object>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry entry = (Map.Entry)entries.get(i);
            builder.append((String)entry.getKey()).append(" = ?");
            params.add(entry.getValue());
            if (i + 1 >= size) continue;
            builder.append(",");
        }
        if (!this.where.isEmpty()) {
            builder.append(this.where.getSql());
            params.addAll(this.where.getParams());
        } else if (primaryValue != null) {
            builder.append(" where ").append(this.primary).append(" = ?");
            params.add(primaryValue);
        } else {
            throw new MagicAPIException("\u4e3b\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sqlModule.update(new BoundSql(runtimeContext, builder.toString(), params, this.sqlModule));
    }

    @Comment(value="\u6267\u884cupdate\u8bed\u53e5")
    public int update(RuntimeContext runtimeContext, @Comment(name="data", value="\u5404\u9879\u5217\u548c\u503c") Map<String, Object> data) {
        return this.update(runtimeContext, data, this.withBlank);
    }

    @Comment(value="\u67e5\u8be2\u6761\u6570")
    public int count(RuntimeContext runtimeContext) {
        this.preHandle(SqlMode.COUNT);
        StringBuilder builder = new StringBuilder();
        builder.append("select count(1) from ").append(this.tableName);
        List<Object> params = this.buildWhere(builder);
        return this.sqlModule.selectInt(new BoundSql(runtimeContext, builder.toString(), params, this.sqlModule));
    }

    @Comment(value="\u5224\u65ad\u662f\u5426\u5b58\u5728")
    public boolean exists(RuntimeContext runtimeContext) {
        return this.count(runtimeContext) > 0;
    }

    private Collection<Map.Entry<String, Object>> filterNotBlanks() {
        if (this.withBlank) {
            return this.columns.entrySet().stream().filter(it -> !this.excludeColumns.contains(it.getKey())).collect(Collectors.toList());
        }
        return this.columns.entrySet().stream().filter(it -> StringUtils.isNotBlank((CharSequence)Objects.toString(it.getValue(), ""))).filter(it -> !this.excludeColumns.contains(it.getKey())).collect(Collectors.toList());
    }

    private void preHandle(SqlMode sqlMode) {
        if (this.namedTableInterceptors != null) {
            this.namedTableInterceptors.forEach(interceptor -> interceptor.preHandle(sqlMode, this));
        }
    }

    private BoundSql buildSelect(RuntimeContext runtimeContext) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        List fields = this.fields.stream().filter(it -> !this.excludeColumns.contains(it)).collect(Collectors.toList());
        if (fields.isEmpty()) {
            builder.append("*");
        } else {
            builder.append(StringUtils.join(fields, (String)","));
        }
        builder.append(" from ").append(this.tableName);
        List<Object> params = this.buildWhere(builder);
        if (!this.orders.isEmpty()) {
            builder.append(" order by ");
            builder.append(String.join((CharSequence)",", this.orders));
        }
        if (!this.groups.isEmpty()) {
            builder.append(" group by ");
            builder.append(String.join((CharSequence)",", this.groups));
        }
        BoundSql boundSql = new BoundSql(runtimeContext, builder.toString(), params, this.sqlModule);
        boundSql.setExcludeColumns(this.excludeColumns);
        return boundSql;
    }

    private List<Object> buildWhere(StringBuilder builder) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (!this.where.isEmpty()) {
            this.where.and();
            this.where.ne(this.useLogic, this.logicDeleteColumn, this.logicDeleteValue);
            builder.append(this.where.getSql());
            params.addAll(this.where.getParams());
        } else if (this.useLogic) {
            this.where.ne(this.logicDeleteColumn, this.logicDeleteValue);
            builder.append(this.where.getSql());
            params.addAll(this.where.getParams());
        }
        return params;
    }

    @Transient
    public String getTableName() {
        return this.tableName;
    }

    @Transient
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Transient
    public SQLModule getSqlModule() {
        return this.sqlModule;
    }

    @Transient
    public String getPrimary() {
        return this.primary;
    }

    @Transient
    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    @Transient
    public Object getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    @Transient
    public Map<String, Object> getColumns() {
        return this.columns;
    }

    @Transient
    public void setColumns(Map<String, Object> columns) {
        this.columns = columns;
    }

    @Transient
    public List<String> getFields() {
        return this.fields;
    }

    @Transient
    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @Transient
    public List<String> getGroups() {
        return this.groups;
    }

    @Transient
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Transient
    public List<String> getOrders() {
        return this.orders;
    }

    @Transient
    public void setOrders(List<String> orders) {
        this.orders = orders;
    }

    @Transient
    public Set<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    @Transient
    public void setExcludeColumns(Set<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    @Transient
    public Object getDefaultPrimaryValue() {
        return this.defaultPrimaryValue;
    }

    @Transient
    public boolean isUseLogic() {
        return this.useLogic;
    }

    @Transient
    public void setUseLogic(boolean useLogic) {
        this.useLogic = useLogic;
    }

    @Transient
    public boolean isWithBlank() {
        return this.withBlank;
    }

    @Transient
    public void setWithBlank(boolean withBlank) {
        this.withBlank = withBlank;
    }

    @Transient
    public Where getWhere() {
        return this.where;
    }

    @Transient
    public RequestEntity getRequestEntity() {
        return RequestContext.getRequestEntity();
    }
}

