/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.util.AsciiBytes;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class NestedArchiveResource
implements ContextResource {
    private final Archive rootArchive;
    private final Archive nestedArchive;
    private final String path;

    public NestedArchiveResource(Archive rootArchive, String path) {
        Assert.isTrue((boolean)path.startsWith("/"), (String)("path '" + path + "' should start with a '/'"));
        this.rootArchive = rootArchive;
        this.path = path;
        this.nestedArchive = this.maybeLocateNestedArchive();
    }

    private Archive maybeLocateNestedArchive() {
        final AsciiBytes strippedPath = new AsciiBytes(this.path.substring(1));
        try {
            List nestedArchives = this.rootArchive.getNestedArchives(new Archive.EntryFilter(){

                public boolean matches(Archive.Entry entry) {
                    return entry.getName().equals((Object)strippedPath);
                }
            });
            Assert.isTrue((nestedArchives.size() <= 1 ? 1 : 0) != 0, (String)("More than 1 entry matched " + this.path + " : " + nestedArchives));
            return nestedArchives.size() == 1 ? (Archive)nestedArchives.get(0) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPathWithinContext() {
        return this.path;
    }

    public boolean exists() {
        return this.nestedArchive != null;
    }

    public boolean isReadable() {
        return this.exists();
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        this.assertExists();
        return this.nestedArchive.getUrl();
    }

    public URI getURI() throws IOException {
        this.assertExists();
        try {
            return this.nestedArchive.getUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public File getFile() throws IOException {
        this.assertExists();
        return new FileSystemResource(this.nestedArchive.getUrl().toExternalForm()).getFile();
    }

    public long contentLength() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long lastModified() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = StringUtils.applyRelativePath((String)this.path, (String)relativePath);
        return new NestedArchiveResource(this.rootArchive, pathToUse);
    }

    public String getFilename() {
        int slash = this.path.lastIndexOf(47);
        return this.path.substring(slash + 1);
    }

    public String getDescription() {
        return this.toString();
    }

    public InputStream getInputStream() throws IOException {
        this.assertExists();
        return this.nestedArchive.getUrl().openStream();
    }

    private void assertExists() throws IOException {
        if (this.nestedArchive == null) {
            throw new IOException("Nested archive at path " + this.path + " does not exist");
        }
    }

    public String toString() {
        return String.format("%s for archive at %s inside %s", this.getClass().getSimpleName(), this.path, this.rootArchive);
    }
}

