/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;

public class EnvironmentAwareModuleOptionsMetadataResolver
implements ModuleOptionsMetadataResolver,
ResourceLoaderAware,
EnvironmentAware {
    private static final String XD_MODULE_CONFIG_LOCATION = "xd.module.config.location";
    private static final String XD_MODULE_CONFIG_NAME = "xd.module.config.name";
    private static final String DEFAULT_XD_MODULE_CONFIG_NAME = "modules";
    private static final String APPLICATION_CONFIGURATION_PROPERTIES = "applicationConfigurationProperties";
    private ModuleOptionsMetadataResolver delegate;
    private String xdModuleConfigLocation;
    private ConfigurableEnvironment rootEnvironment;
    private String configName = "modules";
    private ResourceLoader resourceLoader;
    private ConfigurableEnvironment parentEnvironment;

    @Value(value="${xd.module.config.location:${xd.config.home}/modules/}")
    public void setXdModuleConfigLocation(String xdModuleConfigLocation) {
        Assert.isTrue((boolean)xdModuleConfigLocation.endsWith("/"), (String)String.format("'%s' must end with a '/'", XD_MODULE_CONFIG_LOCATION));
        this.xdModuleConfigLocation = xdModuleConfigLocation;
    }

    @Value(value="${xd.module.config.name:modules}")
    public void setConfigName(String configName) {
        boolean valid = StringUtils.hasText((String)configName) && !configName.endsWith(".properties") && !configName.endsWith(".yml");
        Assert.isTrue((boolean)valid, (String)String.format("'%s' should not be blank, nor end up with a file extension", XD_MODULE_CONFIG_NAME));
        this.configName = configName;
    }

    public void setDelegate(ModuleOptionsMetadataResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public ModuleOptionsMetadata resolve(ModuleDefinition moduleDefinition) {
        ModuleOptionsMetadata wrapped = this.delegate.resolve(moduleDefinition);
        if (wrapped == null) {
            return null;
        }
        return new ModuleOptionsMetadataWithDefaults(wrapped, moduleDefinition);
    }

    private Environment lookupEnvironment(ModuleDefinition moduleDefinition) {
        this.rootEnvironment = this.loadPropertySources(this.xdModuleConfigLocation, this.configName);
        String propertySourceName = String.format("%s:%s", new Object[]{moduleDefinition.getType(), moduleDefinition.getName()});
        String path = String.format("%s%s/%s/", new Object[]{this.xdModuleConfigLocation, moduleDefinition.getType(), moduleDefinition.getName()});
        ConfigurableEnvironment throwAwayEnvironment = this.loadPropertySources(path, moduleDefinition.getName());
        EnumerablePropertySource nakedPS = (EnumerablePropertySource)throwAwayEnvironment.getPropertySources().get(APPLICATION_CONFIGURATION_PROPERTIES);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : nakedPS.getPropertyNames()) {
            values.put(this.fullyQualifiedKey(moduleDefinition, name), nakedPS.getProperty(name));
        }
        MapPropertySource modulePS = new MapPropertySource(propertySourceName, values);
        StandardEnvironment moduleEnvironment = new StandardEnvironment();
        moduleEnvironment.merge(this.rootEnvironment);
        moduleEnvironment.getPropertySources().addBefore(APPLICATION_CONFIGURATION_PROPERTIES, (PropertySource)modulePS);
        return moduleEnvironment;
    }

    private String fullyQualifiedKey(ModuleDefinition moduleDefinition, String optionName) {
        return String.format("%s.%s.%s", new Object[]{moduleDefinition.getType(), moduleDefinition.getName(), optionName});
    }

    private ConfigurableEnvironment loadPropertySources(final String searchLocation, final String baseName) {
        StandardEnvironment environment = new StandardEnvironment();
        environment.merge(this.parentEnvironment);
        new ConfigFileApplicationListener((ConfigurableEnvironment)environment){
            final /* synthetic */ ConfigurableEnvironment val$environment;
            {
                this.val$environment = configurableEnvironment;
            }

            public void apply() {
                this.setSearchLocations(searchLocation);
                Map<String, String> singletonMap = Collections.singletonMap("spring.config.name", baseName);
                this.val$environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("searchNamesOverride", singletonMap));
                this.addPropertySources(this.val$environment, EnvironmentAwareModuleOptionsMetadataResolver.this.resourceLoader);
            }
        }.apply();
        return environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.parentEnvironment = (ConfigurableEnvironment)environment;
    }

    private class ModuleOptionsMetadataWithDefaults
    implements ModuleOptionsMetadata {
        private final ModuleOptionsMetadata wrapped;
        private final ModuleDefinition moduleDefinition;

        public ModuleOptionsMetadataWithDefaults(ModuleOptionsMetadata wrapped, ModuleDefinition moduleDefinition) {
            this.wrapped = wrapped;
            this.moduleDefinition = moduleDefinition;
            Environment moduleEnvironment = EnvironmentAwareModuleOptionsMetadataResolver.this.lookupEnvironment(moduleDefinition);
            for (ModuleOption original : wrapped) {
                Object newDefault = this.computeDefault(original, moduleEnvironment);
                if (newDefault == null) continue;
                original.withDefaultValue(newDefault);
            }
        }

        @Override
        public Iterator<ModuleOption> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public ModuleOptions interpolate(Map<String, String> raw) throws BindException {
            HashMap<String, String> rawPlusDefaults = new HashMap<String, String>(raw);
            for (ModuleOption option : this.wrapped) {
                if (raw.containsKey(option.getName()) || option.getDefaultValue() == null) continue;
                rawPlusDefaults.put(option.getName(), "" + option.getDefaultValue());
            }
            return this.wrapped.interpolate(rawPlusDefaults);
        }

        private Object computeDefault(ModuleOption option, Environment moduleEnvironment) {
            String fqKey = EnvironmentAwareModuleOptionsMetadataResolver.this.fullyQualifiedKey(this.moduleDefinition, option.getName());
            return moduleEnvironment.getProperty(fqKey);
        }
    }
}

