/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.ParentContextCloserApplicationListener;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ContextIdApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.validation.BindException;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.core.AbstractModule;
import org.springframework.xd.module.core.ModuleEnvironment;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.PassthruModuleOptionsMetadata;

public abstract class SimpleModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConfigurableApplicationContext context;
    private final SpringApplicationBuilder application;
    private final AtomicInteger propertiesCounter = new AtomicInteger();
    private final Properties properties = new Properties();
    private final MutablePropertySources propertySources = new MutablePropertySources();
    private ConfigurableApplicationContext parent;
    private final List<ApplicationListener<?>> listeners = new ArrayList();
    private ModuleOptions moduleOptions;
    private final ClassLoader classLoader;

    public SimpleModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties) {
        this(descriptor, deploymentProperties, null, SimpleModule.defaultModuleOptions());
    }

    public SimpleModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties, ClassLoader classLoader, ModuleOptions moduleOptions) {
        super(descriptor, deploymentProperties);
        this.moduleOptions = moduleOptions;
        this.application = new SpringApplicationBuilder(new Object[0]).sources(new Class[]{PropertyPlaceholderAutoConfiguration.class}).web(false).showBanner(false);
        this.classLoader = classLoader;
        if (classLoader != null) {
            this.application.resourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver(classLoader));
        }
        this.properties.putAll(this.moduleOptionsToProperties(moduleOptions));
        this.application.profiles(moduleOptions.profilesToActivate());
        this.configureModuleApplicationContext((SimpleModuleDefinition)this.getDescriptor().getModuleDefinition());
    }

    protected abstract void configureModuleApplicationContext(SimpleModuleDefinition var1);

    private Map<Object, Object> moduleOptionsToProperties(ModuleOptions moduleOptions) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        EnumerablePropertySource<?> ps = moduleOptions.asPropertySource();
        for (String propname : ps.getPropertyNames()) {
            Object value = ps.getProperty(propname);
            if (value == null) continue;
            result.put(propname, value.toString());
        }
        return result;
    }

    @Override
    public void setParentContext(ApplicationContext parent) {
        this.parent = (ConfigurableApplicationContext)parent;
    }

    @Override
    public void addSource(Object source) {
        this.application.sources(new Object[]{source});
    }

    @Override
    public void addProperties(Properties properties) {
        this.registerPropertySource(properties);
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void addListener(ApplicationListener<?> listener) {
        this.listeners.add(listener);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.context;
    }

    @Override
    public <T> T getComponent(Class<T> requiredType) {
        return (T)(this.context.isActive() ? this.context.getBean(requiredType) : null);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public <T> T getComponent(String componentName, Class<T> requiredType) {
        if (this.context.isActive() && this.context.containsBean(componentName)) {
            return (T)this.context.getBean(componentName, requiredType);
        }
        return null;
    }

    private void registerPropertySource(Properties properties) {
        int propertiesIndex = this.propertiesCounter.getAndIncrement();
        String propertySourceName = "properties-" + propertiesIndex;
        PropertiesPropertySource propertySource = new PropertiesPropertySource(propertySourceName, properties);
        this.propertySources.addLast((PropertySource)propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.application.initializers(new ApplicationContextInitializer[]{new ContextIdApplicationContextInitializer(this.toString())});
        ConfigurableEnvironment parentEnvironment = this.parent == null ? null : this.parent.getEnvironment();
        ModuleEnvironment environment = new ModuleEnvironment(this.moduleOptions.asPropertySource(), parentEnvironment);
        for (PropertySource source : this.propertySources) {
            environment.getPropertySources().addFirst(source);
        }
        this.application.parent(this.parent);
        this.application.environment((ConfigurableEnvironment)environment);
        if (this.listeners.size() > 0) {
            this.application.listeners(this.listeners.toArray(new ApplicationListener[this.listeners.size()]));
        }
        this.application.listeners(new ApplicationListener[]{new ModuleParentContextCloserApplicationListener(this.getDescriptor().getIndex())});
        if (this.classLoader != null) {
            ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.context = this.application.run(new String[0]);
            }
            finally {
                Thread.currentThread().setContextClassLoader(defaultClassLoader);
            }
        } else {
            this.context = this.application.run(new String[0]);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("initialized module: " + this.toString());
        }
    }

    public void start() {
        try {
            this.context.start();
        }
        catch (BeansException be) {
            this.destroy();
            throw be;
        }
    }

    public void stop() {
        if (this.context.isActive()) {
            this.context.stop();
        }
    }

    public boolean isRunning() {
        return this.context.isRunning();
    }

    @Override
    public void destroy() {
        if (this.context instanceof DisposableBean) {
            try {
                ((DisposableBean)this.context).destroy();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static ModuleOptions defaultModuleOptions() {
        try {
            return new PassthruModuleOptionsMetadata().interpolate(Collections.emptyMap());
        }
        catch (BindException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class ModuleParentContextCloserApplicationListener
    extends ParentContextCloserApplicationListener {
        private final int index;

        public ModuleParentContextCloserApplicationListener(int index) {
            this.index = index;
        }

        protected ParentContextCloserApplicationListener.ContextCloserListener createContextCloserListener(ConfigurableApplicationContext child) {
            return new ModuleContextCloserListener(child, this.index);
        }

        static final class ModuleContextCloserListener
        extends ParentContextCloserApplicationListener.ContextCloserListener
        implements Ordered {
            private int index;

            public ModuleContextCloserListener(ConfigurableApplicationContext moduleContext, int index) {
                super(moduleContext);
                this.index = index;
            }

            public int getOrder() {
                return this.index;
            }
        }
    }
}

