/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.core.CompositeModule;
import org.springframework.xd.module.core.JavaConfiguredModule;
import org.springframework.xd.module.core.Module;
import org.springframework.xd.module.core.NonBindingResourceConfiguredModule;
import org.springframework.xd.module.core.ResourceConfiguredModule;
import org.springframework.xd.module.core.SimpleModule;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.module.options.ModuleUtils;
import org.springframework.xd.module.options.PrefixNarrowingModuleOptions;

public class ModuleFactory
implements BeanClassLoaderAware {
    private static Logger log = LoggerFactory.getLogger(ModuleFactory.class);
    private final ModuleOptionsMetadataResolver moduleOptionsMetadataResolver;
    private volatile ClassLoader parentClassLoader = ModuleFactory.class.getClassLoader();
    public static final String MODULE_EXECUTION_FRAMEWORK_KEY = "moduleExecutionFramework";

    public ModuleFactory(ModuleOptionsMetadataResolver moduleOptionsMetadataResolver) {
        Assert.notNull((Object)moduleOptionsMetadataResolver, (String)"'moduleOptionsMetadataResolver' cannot be null");
        this.moduleOptionsMetadataResolver = moduleOptionsMetadataResolver;
    }

    public Module createModule(ModuleDescriptor moduleDescriptor, ModuleDeploymentProperties deploymentProperties) {
        ModuleOptions moduleOptions = this.safeModuleOptionsInterpolate(moduleDescriptor);
        Module module = this.createAndConfigureModuleInstance(moduleDescriptor, moduleOptions, deploymentProperties);
        return module;
    }

    private Module createAndConfigureModuleInstance(ModuleDescriptor moduleDescriptor, ModuleOptions moduleOptions, ModuleDeploymentProperties deploymentProperties) {
        Module module = moduleDescriptor.isComposed() ? this.createCompositeModule(moduleDescriptor, moduleOptions, deploymentProperties) : this.createSimpleModule(moduleDescriptor, moduleOptions, deploymentProperties);
        return module;
    }

    private Module createSimpleModule(ModuleDescriptor moduleDescriptor, ModuleOptions moduleOptions, ModuleDeploymentProperties deploymentProperties) {
        if (log.isInfoEnabled()) {
            log.info("creating simple module " + moduleDescriptor);
        }
        SimpleModuleDefinition definition = (SimpleModuleDefinition)moduleDescriptor.getModuleDefinition();
        ClassLoader moduleClassLoader = ModuleUtils.createModuleRuntimeClassLoader(definition, moduleOptions, this.parentClassLoader);
        Class<? extends SimpleModule> moduleClass = this.determineModuleClass((SimpleModuleDefinition)moduleDescriptor.getModuleDefinition(), moduleOptions);
        Assert.notNull(moduleClass, (String)String.format("Required module artifacts are either missing or invalid. Unable to determine module type for module definition: '%s:%s'.", new Object[]{moduleDescriptor.getType(), moduleDescriptor.getModuleName()}));
        return SimpleModuleCreator.createModule(moduleDescriptor, deploymentProperties, moduleClassLoader, moduleOptions, moduleClass);
    }

    private Class<? extends SimpleModule> determineModuleClass(SimpleModuleDefinition moduleDefinition, ModuleOptions moduleOptions) {
        String name = (String)moduleOptions.asPropertySource().getProperty(MODULE_EXECUTION_FRAMEWORK_KEY);
        if ("spark".equals(name)) {
            return NonBindingResourceConfiguredModule.class;
        }
        if (ModuleUtils.resourceBasedConfigurationFile(moduleDefinition) != null) {
            return ResourceConfiguredModule.class;
        }
        if (JavaConfiguredModule.basePackages(moduleDefinition).length > 0) {
            return JavaConfiguredModule.class;
        }
        return null;
    }

    private Module createCompositeModule(ModuleDescriptor compositeDescriptor, ModuleOptions options, ModuleDeploymentProperties deploymentProperties) {
        List<ModuleDescriptor> children = compositeDescriptor.getChildren();
        Assert.notEmpty(children, (String)"child module list must not be empty");
        if (log.isInfoEnabled()) {
            log.info("creating composite module " + compositeDescriptor);
        }
        ArrayList<Module> childrenModules = new ArrayList<Module>(children.size());
        for (ModuleDescriptor moduleDescriptor : children) {
            PrefixNarrowingModuleOptions moduleOptions = new PrefixNarrowingModuleOptions(options, moduleDescriptor.getModuleName());
            childrenModules.add(0, this.createAndConfigureModuleInstance(moduleDescriptor, moduleOptions, deploymentProperties));
        }
        return new CompositeModule(compositeDescriptor, deploymentProperties, childrenModules);
    }

    private ModuleOptions safeModuleOptionsInterpolate(ModuleDescriptor descriptor) {
        Map<String, String> parameters = descriptor.getParameters();
        ModuleOptionsMetadata moduleOptionsMetadata = this.moduleOptionsMetadataResolver.resolve(descriptor.getModuleDefinition());
        try {
            return moduleOptionsMetadata.interpolate(parameters);
        }
        catch (BindException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    static class SimpleModuleCreator {
        SimpleModuleCreator() {
        }

        public static <T extends SimpleModule> T createModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties, ClassLoader classLoader, ModuleOptions moduleOptions, Class<T> requiredType) {
            Constructor<T> constructor = null;
            try {
                constructor = requiredType.getConstructor(ModuleDescriptor.class, ModuleDeploymentProperties.class, ClassLoader.class, ModuleOptions.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                return (T)((SimpleModule)constructor.newInstance(descriptor, deploymentProperties, classLoader, moduleOptions));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

