/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.springframework.scheduling.support.CronSequenceGenerator;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={CronValidator.class})
public @interface CronExpression {
    public static final String DEFAULT_MESSAGE = "";

    public String message() default "";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class CronValidator
    implements ConstraintValidator<CronExpression, CharSequence> {
        private String message;

        public void initialize(CronExpression constraintAnnotation) {
            this.message = constraintAnnotation.message();
        }

        public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
            if (value == null) {
                return true;
            }
            try {
                new CronSequenceGenerator(value.toString());
            }
            catch (IllegalArgumentException e) {
                if (CronExpression.DEFAULT_MESSAGE.equals(this.message)) {
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
                }
                return false;
            }
            return true;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public CronExpression[] value();
    }
}

