/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.springframework.xd.module.options.spi.ModuleOption;

public class MongoDbConnectionMixin {
    private String databaseName = "xd";
    private String host = "localhost";
    private int port = 27017;
    private String username = "";
    private String password = "";
    private String authenticationDatabaseName = "";

    @ModuleOption(value="the MongoDB database name")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @ModuleOption(value="the MongoDB host to connect to")
    public void setHost(String host) {
        this.host = host;
    }

    @ModuleOption(value="the MongoDB port to connect to")
    public void setPort(int port) {
        this.port = port;
    }

    @ModuleOption(value="the MongoDB password used for connecting")
    public void setPassword(String password) {
        this.password = password;
    }

    @ModuleOption(value="the MongoDB username used for connecting")
    public void setUsername(String username) {
        this.username = username;
    }

    @ModuleOption(value="the MongoDB authentication database used for connecting")
    public void setAuthenticationDatabaseName(String authenticationDatabaseName) {
        this.authenticationDatabaseName = authenticationDatabaseName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuthenticationDatabaseName() {
        return this.authenticationDatabaseName;
    }

    @NotBlank
    public String getDatabaseName() {
        return this.databaseName;
    }

    @NotBlank
    public String getHost() {
        return this.host;
    }

    @Range(min=0L, max=65535L)
    public int getPort() {
        return this.port;
    }
}

