/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import javax.validation.constraints.AssertTrue;
import org.springframework.xd.module.options.mixins.ScriptMixin;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public class ExpressionOrScriptMixin
extends ScriptMixin
implements ProfileNamesProvider {
    private static final String DEFAULT_EXPRESSION = "payload.toString()";
    private String expression;

    public String getExpression() {
        return this.expression == null ? DEFAULT_EXPRESSION : this.expression;
    }

    @ModuleOption(value="a SpEL expression used to transform messages")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    @AssertTrue(message="the 'script' and 'expression' options are mutually exclusive")
    public boolean isValid() {
        return this.getScript() == null || this.expression.equals(DEFAULT_EXPRESSION);
    }

    @AssertTrue(message="'propertiesLocation' and 'variables' only apply to script")
    public boolean noScriptOptionsWithExpression() {
        return this.getScript() == null ^ (this.getPropertiesLocation() == null && this.getVariables() == null);
    }

    @Override
    public String[] profilesToActivate() {
        String[] stringArray;
        if (this.getScript() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "use-expression";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "use-script";
        }
        return stringArray;
    }
}

