/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.xd.store.RangeCapableRepository;

public abstract class AbstractRedisRepository<T, ID extends Serializable & Comparable<ID>>
implements PagingAndSortingRepository<T, ID>,
RangeCapableRepository<T, ID> {
    protected String repoPrefix;
    protected BoundZSetOperations<String, String> zSetOperations;
    protected RedisOperations<String, String> redisOperations;

    public AbstractRedisRepository(String repoPrefix, RedisOperations<String, String> redisOperations) {
        Assert.hasText((String)repoPrefix, (String)"repoPrefix must not be empty or null");
        Assert.notNull(redisOperations, (String)"redisOperations must not be null");
        this.redisOperations = redisOperations;
        this.setPrefix(repoPrefix);
    }

    public long count() {
        return this.zSetOperations.size();
    }

    public void delete(ID id) {
        if (this.zSetOperations.remove(new Object[]{this.redisKeyFromId(id)}) == 1L) {
            this.redisOperations.delete((Object)this.redisKeyFromId(id));
        }
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete((T)this.keyFor(entity));
        }
    }

    public void delete(T entity) {
        ID id = this.keyFor(entity);
        if (this.zSetOperations.remove(new Object[]{this.redisKeyFromId(id)}) == 1L) {
            this.redisOperations.delete((Object)this.redisKeyFromId(id));
        }
    }

    public void deleteAll() {
        Set keys = this.zSetOperations.range(0L, -1L);
        this.zSetOperations.removeRange(0L, -1L);
        this.redisOperations.delete((Collection)keys);
    }

    public boolean exists(ID id) {
        return this.redisOperations.hasKey((Object)this.redisKeyFromId(id));
    }

    public Iterable<T> findAll() {
        Set keys = this.zSetOperations.range(0L, -1L);
        Iterator keysIt = keys.iterator();
        ArrayList<T> result = new ArrayList<T>(keys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)keys);
        for (String v : values) {
            result.add(this.deserialize(this.idFromRedisKey((String)keysIt.next()), v));
        }
        return result;
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        ArrayList<String> redisKeys = new ArrayList<String>();
        for (Serializable id : ids) {
            redisKeys.add(this.redisKeyFromId(id));
        }
        Iterator keysIt = redisKeys.iterator();
        ArrayList<T> result = new ArrayList<T>(redisKeys.size());
        List values = this.redisOperations.opsForValue().multiGet(redisKeys);
        for (String v : values) {
            result.add(this.deserialize(this.idFromRedisKey((String)keysIt.next()), v));
        }
        return result;
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.isNull((Object)pageable.getSort(), (String)"Arbitrary sorting is not implemented");
        long count = this.zSetOperations.size();
        long to = Math.min(count, (long)(pageable.getOffset() + pageable.getPageSize())) - 1L;
        Set redisKeys = to == -1L ? Collections.emptySet() : this.zSetOperations.range((long)pageable.getOffset(), to);
        Iterator keysIt = redisKeys.iterator();
        ArrayList<T> result = new ArrayList<T>(redisKeys.size());
        List values = this.redisOperations.opsForValue().multiGet((Collection)redisKeys);
        for (String v : values) {
            result.add(this.deserialize(this.idFromRedisKey((String)keysIt.next()), v));
        }
        return new PageImpl(result, pageable, count);
    }

    public Iterable<T> findAll(Sort sort) {
        throw new UnsupportedOperationException("Can't sort on arbitrary property");
    }

    public T findOne(ID id) {
        String redisKey = this.redisKeyFromId(id);
        String raw = (String)this.redisOperations.opsForValue().get((Object)redisKey);
        if (raw != null) {
            return this.deserialize(this.idFromRedisKey(redisKey), raw);
        }
        return null;
    }

    public <S extends T> S save(S entity) {
        String raw = this.serialize(entity);
        String redisKey = this.redisKeyFromId(this.keyFor(entity));
        this.trackMembership(redisKey);
        this.redisOperations.opsForValue().set((Object)redisKey, (Object)raw);
        return entity;
    }

    @Override
    public Iterable<T> findAllInRange(ID from, boolean fromInclusive, ID to, boolean toInclusive) {
        Set keys = this.zSetOperations.range(0L, -1L);
        String fromRedis = this.redisKeyFromId(from);
        String toRedis = this.redisKeyFromId(to);
        NavigableSet<String> subSet = new TreeSet<String>(keys).subSet(fromRedis, fromInclusive, toRedis, toInclusive);
        Iterator keysIt = subSet.iterator();
        ArrayList<T> result = new ArrayList<T>(subSet.size());
        List values = this.redisOperations.opsForValue().multiGet(subSet);
        for (String v : values) {
            result.add(this.deserialize(this.idFromRedisKey((String)keysIt.next()), v));
        }
        return result;
    }

    protected void trackMembership(String redisKey) {
        this.zSetOperations.add((Object)redisKey, 0.0);
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        for (S entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    protected abstract T deserialize(ID var1, String var2);

    protected abstract String serialize(T var1);

    protected abstract ID keyFor(T var1);

    protected abstract String serializeId(ID var1);

    protected abstract ID deserializeId(String var1);

    protected String redisKeyFromId(ID id) {
        Assert.notNull(id);
        return this.repoPrefix + "." + this.serializeId(id);
    }

    protected ID idFromRedisKey(String redisKey) {
        String serialized = redisKey.substring(this.repoPrefix.length() + 1);
        return this.deserializeId(serialized);
    }

    public void setPrefix(String string) {
        this.repoPrefix = string;
        this.zSetOperations = this.redisOperations.boundZSetOps((Object)this.repoPrefix);
    }

    protected String getPrefix() {
        return this.repoPrefix;
    }
}

