/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.util.Assert;
import org.springframework.xd.store.AbstractRepository;
import org.springframework.xd.store.RangeCapableRepository;

public abstract class AbstractInMemoryRepository<T, ID extends Serializable & Comparable<ID>>
extends AbstractRepository<T, ID>
implements PagingAndSortingRepository<T, ID>,
RangeCapableRepository<T, ID> {
    private final NavigableMap<ID, T> map = this.buildMap();

    protected AbstractInMemoryRepository() {
    }

    protected NavigableMap<ID, T> buildMap() {
        return new ConcurrentSkipListMap();
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity);
        this.map.put(this.safeKeyFor(entity), entity);
        return entity;
    }

    private final ID safeKeyFor(T entity) {
        ID k = this.keyFor(entity);
        Assert.notNull(k);
        return k;
    }

    protected abstract ID keyFor(T var1);

    public T findOne(ID id) {
        Assert.notNull(id);
        return (T)this.map.get(id);
    }

    public Iterable<T> findAll() {
        return new ArrayList(this.map.values());
    }

    public long count() {
        return this.map.size();
    }

    public void delete(ID id) {
        Assert.notNull(id);
        this.map.remove(id);
    }

    public void delete(T entity) {
        Assert.notNull(entity);
        this.map.remove(this.safeKeyFor(entity));
    }

    public void deleteAll() {
        this.map.clear();
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.isNull((Object)pageable.getSort(), (String)"Arbitrary sorting is not implemented");
        return this.slice((List)this.findAll(), pageable);
    }

    protected Page<T> slice(List<T> list, Pageable pageable) {
        int to = Math.min(list.size(), pageable.getOffset() + pageable.getPageSize());
        List<T> data = list.subList(pageable.getOffset(), to);
        return new PageImpl(data, pageable, (long)list.size());
    }

    public Iterable<T> findAll(Sort sort) {
        throw new UnsupportedOperationException("Arbitrary sorting is not implemented");
    }

    @Override
    public Iterable<T> findAllInRange(ID from, boolean fromInclusive, ID to, boolean toInclusive) {
        return this.map.subMap(from, fromInclusive, to, toInclusive).values();
    }
}

