/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.util.Assert;

class AggregateKeyGenerator {
    static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmm");
    public static final String SEPARATOR = ".";
    private final String hourKey;
    private final String dayKey;
    private final String monthKey;
    private final String yearKey;
    private final String yearsKey;
    private final String totalKey;
    private final String year;
    private final String minute;
    private final String hour;
    private final String day;
    private final String month;
    private final String repoPrefix;
    private final String counterName;

    public AggregateKeyGenerator(String repoPrefix, String counterName) {
        this(repoPrefix, counterName, (ReadableDateTime)new DateTime());
    }

    public AggregateKeyGenerator(String repoPrefix, String counterName, ReadableDateTime dateTime) {
        Assert.notNull((Object)counterName, (String)"Counter name name can not be null");
        Assert.notNull((Object)dateTime, (String)"DateTime can not be null");
        this.repoPrefix = repoPrefix;
        this.counterName = counterName;
        String timeStamp = dateTimeFormatter.print((ReadableInstant)dateTime);
        this.totalKey = this.key("total");
        this.hourKey = this.key(timeStamp.substring(0, 10));
        this.dayKey = this.key(timeStamp.substring(0, 8));
        this.monthKey = this.key(timeStamp.substring(0, 6));
        this.yearKey = this.key(timeStamp.substring(0, 4));
        this.yearsKey = this.key("years");
        this.minute = timeStamp.substring(10, 12);
        this.hour = timeStamp.substring(8, 10);
        this.day = timeStamp.substring(6, 8);
        this.month = timeStamp.substring(4, 6);
        this.year = timeStamp.substring(0, 4);
    }

    public String getYearsKey() {
        return this.yearsKey;
    }

    public String getTotalKey() {
        return this.totalKey;
    }

    private String key(String suffix) {
        return this.repoPrefix + SEPARATOR + this.counterName + SEPARATOR + suffix;
    }

    public String getHourKey() {
        return this.hourKey;
    }

    public String getDayKey() {
        return this.dayKey;
    }

    public String getMonthKey() {
        return this.monthKey;
    }

    public String getYearKey() {
        return this.yearKey;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getHour() {
        return this.hour;
    }

    public String getDay() {
        return this.day;
    }

    public String getMonth() {
        return this.month;
    }

    public String getYear() {
        return this.year;
    }
}

