/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Metric;
import org.springframework.xd.analytics.metrics.core.MetricRepository;

public abstract class InMemoryMetricRepository<M extends Metric>
implements MetricRepository<M> {
    private final ConcurrentMap<String, M> map = new ConcurrentHashMap<String, M>();

    public <S extends M> S save(S metric) {
        this.map.put(metric.getName(), metric);
        return metric;
    }

    public <S extends M> Iterable<S> save(Iterable<S> metrics) {
        ArrayList<Metric> results = new ArrayList<Metric>();
        for (Metric m : metrics) {
            results.add(this.save((S)m));
        }
        return results;
    }

    public void delete(String name) {
        Assert.notNull((Object)name, (String)"The name of the metric must not be null");
        this.map.remove(name);
    }

    public void delete(M metric) {
        Assert.notNull(metric, (String)"The metric instance must not be null");
        this.map.remove(metric.getName());
    }

    public void delete(Iterable<? extends M> metrics) {
        for (Metric metric : metrics) {
            this.delete((M)metric);
        }
    }

    public M findOne(String name) {
        Assert.notNull((Object)name, (String)"The name of the metric must not be null");
        return (M)((Metric)this.map.get(name));
    }

    public boolean exists(String s) {
        return this.findOne(s) != null;
    }

    public List<M> findAll() {
        return new ArrayList(this.map.values());
    }

    public List<M> findAll(Iterable<String> keys) {
        ArrayList<M> results = new ArrayList<M>();
        for (String k : keys) {
            M value = this.findOne(k);
            if (value == null) continue;
            results.add(value);
        }
        return results;
    }

    public long count() {
        return this.map.size();
    }

    public void deleteAll() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected M getOrCreate(String name) {
        ConcurrentMap<String, M> concurrentMap = this.map;
        synchronized (concurrentMap) {
            M result = this.findOne(name);
            if (result == null) {
                result = this.create(name);
                result = this.save((S)result);
            }
            return result;
        }
    }

    protected abstract M create(String var1);
}

