/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.RichGaugeRepository;
import org.springframework.xd.analytics.metrics.integration.AbstractMetricHandler;

public class RichGaugeHandler
extends AbstractMetricHandler {
    private final RichGaugeRepository richGaugeRepository;
    private final double alpha;

    public RichGaugeHandler(RichGaugeRepository richGaugeRepository, String nameExpression, double alpha) {
        super(nameExpression);
        this.alpha = alpha;
        Assert.notNull((Object)richGaugeRepository, (String)"Rich Gauge Repository can not be null");
        this.richGaugeRepository = richGaugeRepository;
    }

    @ServiceActivator
    public void process(Message<?> message) {
        if (message != null) {
            double value = this.convertToDouble(message.getPayload());
            this.richGaugeRepository.recordValue(this.computeMetricName(message), value, this.alpha);
        }
    }

    double convertToDouble(Object payload) {
        if (payload != null) {
            if (payload instanceof Number) {
                return ((Number)payload).doubleValue();
            }
            if (payload instanceof String) {
                try {
                    return Double.parseDouble((String)payload);
                }
                catch (Exception e) {
                    throw new MessagingException("cannot convert payload to double", (Throwable)e);
                }
            }
        }
        throw new MessagingException("cannot convert " + (payload == null ? "null" : payload.getClass().getName() + " to double"));
    }
}

