/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.GaugeRepository;
import org.springframework.xd.analytics.metrics.integration.AbstractMetricHandler;

public class GaugeHandler
extends AbstractMetricHandler {
    private final GaugeRepository gaugeRepository;

    public GaugeHandler(GaugeRepository gaugeRepository, String nameExpression) {
        super(nameExpression);
        Assert.notNull((Object)gaugeRepository, (String)"Gauge Repository can not be null");
        this.gaugeRepository = gaugeRepository;
    }

    @ServiceActivator
    public void process(Message<?> message) {
        if (message != null) {
            long value = this.convertToLong(message.getPayload());
            this.gaugeRepository.recordValue(this.computeMetricName(message), value);
        }
    }

    long convertToLong(Object payload) {
        if (payload != null) {
            if (payload instanceof Number) {
                return ((Number)payload).longValue();
            }
            if (payload instanceof String) {
                try {
                    return Long.parseLong((String)payload);
                }
                catch (Exception e) {
                    throw new MessagingException("cannot convert payload to long", (Throwable)e);
                }
            }
        }
        throw new MessagingException("cannot convert " + (payload == null ? "null" : payload.getClass().getName() + " to long"));
    }
}

