/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.core;

import java.util.Arrays;
import org.joda.time.Interval;
import org.springframework.xd.analytics.metrics.core.AggregateCountResolution;

public class AggregateCount {
    private final String name;
    private final Interval interval;
    private final long[] counts;
    private final AggregateCountResolution resolution;

    public AggregateCount(String name, Interval interval, long[] counts, AggregateCountResolution resolution) {
        this.name = name;
        this.interval = interval;
        this.counts = (long[])counts.clone();
        this.resolution = resolution;
    }

    public int getTotal() {
        int total = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            total = (int)((long)total + this.counts[i]);
        }
        return total;
    }

    public String getName() {
        return this.name;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public long[] getCounts() {
        return this.counts;
    }

    public AggregateCountResolution getResolution() {
        return this.resolution;
    }

    public String toString() {
        return "AggregateCount{name='" + this.name + '\'' + ", interval=" + this.interval + ", counts=" + Arrays.toString(this.counts) + ", resolution=" + (Object)((Object)this.resolution) + '}';
    }
}

