/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.xml.DocumentBuilderFactoryUtils;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.transform.ResourceSource;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SimpleXsdSchema
implements XsdSchema,
InitializingBean {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactoryUtils.newInstance();
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_NAME = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xsd");
    private Resource xsdResource;
    private String targetNamespace;

    public SimpleXsdSchema() {
    }

    public SimpleXsdSchema(Resource xsdResource) {
        Assert.notNull((Object)xsdResource, (String)"xsdResource must not be null");
        this.xsdResource = xsdResource;
    }

    public void setXsd(Resource xsdResource) {
        this.xsdResource = xsdResource;
    }

    @Override
    public String getTargetNamespace() {
        Assert.state((this.targetNamespace != null ? 1 : 0) != 0, () -> "'targetNamespace' cannot be accessed before afterPropertiesSet() has been called on this instance");
        return this.targetNamespace;
    }

    @Override
    public Source getSource() {
        Assert.state((this.xsdResource != null ? 1 : 0) != 0, () -> "Source cannot be created from a null XSD resource");
        try {
            return new ResourceSource(this.xsdResource);
        }
        catch (IOException ex) {
            throw new XsdSchemaException(ex.getMessage(), ex);
        }
    }

    @Override
    public XmlValidator createValidator() {
        Assert.state((this.xsdResource != null ? 1 : 0) != 0, () -> "XmlValidator cannot be created from a null XSD resource");
        try {
            return XmlValidatorFactory.createValidator(this.xsdResource, SCHEMA_NAMESPACE);
        }
        catch (IOException ex) {
            throw new XsdSchemaException(ex.getMessage(), ex);
        }
    }

    public void afterPropertiesSet() throws ParserConfigurationException, IOException, SAXException {
        Assert.notNull((Object)this.xsdResource, (String)"'xsd' is required");
        Assert.isTrue((boolean)this.xsdResource.exists(), (String)("xsd '" + String.valueOf(this.xsdResource) + "' does not exist"));
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.loadSchema(documentBuilder);
    }

    private void loadSchema(DocumentBuilder documentBuilder) throws SAXException, IOException {
        Document schemaDocument = documentBuilder.parse(SaxUtils.createInputSource(this.xsdResource));
        Element schemaElement = schemaDocument.getDocumentElement();
        Assert.isTrue((boolean)SCHEMA_NAME.getLocalPart().equals(schemaElement.getLocalName()), (String)(String.valueOf(this.xsdResource) + " has invalid root element : [" + schemaElement.getLocalName() + "] instead of [schema]"));
        Assert.isTrue((boolean)SCHEMA_NAME.getNamespaceURI().equals(schemaElement.getNamespaceURI()), (String)(String.valueOf(this.xsdResource) + " has invalid root element: [" + schemaElement.getNamespaceURI() + "] instead of [" + SCHEMA_NAME.getNamespaceURI() + "]"));
        String targetNamespace = schemaElement.getAttribute("targetNamespace");
        Assert.hasText((String)targetNamespace, (String)(String.valueOf(this.xsdResource) + " has no targetNamespace"));
        this.targetNamespace = targetNamespace;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SimpleXsdSchema");
        builder.append('{');
        builder.append(this.getTargetNamespace());
        builder.append('}');
        return builder.toString();
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
    }
}

