/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.namespace;

import java.beans.PropertyEditorSupport;
import javax.xml.namespace.QName;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.QNameUtils;

public class QNameEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(QNameUtils.parseQNameString(text));
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value == null || !(value instanceof QName)) {
            return "";
        }
        QName qName = (QName)value;
        String prefix = QNameUtils.getPrefix(qName);
        if (StringUtils.hasLength((String)qName.getNamespaceURI()) && StringUtils.hasLength((String)prefix)) {
            return "{" + qName.getNamespaceURI() + "}" + prefix + ":" + qName.getLocalPart();
        }
        if (StringUtils.hasLength((String)qName.getNamespaceURI())) {
            return "{" + qName.getNamespaceURI() + "}" + qName.getLocalPart();
        }
        return qName.getLocalPart();
    }
}

