/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.creator;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.creator.AbstractMessageCreator;
import org.springframework.xml.transform.TransformerHelper;
import org.w3c.dom.Document;

public class SoapEnvelopeMessageCreator
extends AbstractMessageCreator {
    private final Source soapEnvelope;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public SoapEnvelopeMessageCreator(Source soapEnvelope) {
        Assert.notNull((Object)soapEnvelope, (String)"'soapEnvelope' must not be null");
        this.soapEnvelope = soapEnvelope;
    }

    protected void doWithMessage(WebServiceMessage message) throws IOException {
        AssertionErrors.assertTrue("Message created with factory is not a SOAP message", message instanceof SoapMessage);
        SoapMessage soapMessage = (SoapMessage)message;
        try {
            DOMResult result = new DOMResult();
            this.transformerHelper.transform(this.soapEnvelope, result);
            soapMessage.setDocument((Document)result.getNode());
        }
        catch (TransformerException ex) {
            AssertionErrors.fail("Could not transform request SOAP envelope to message: " + ex.getMessage());
        }
    }
}

