/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback.jaas;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.springframework.ws.soap.security.xwss.callback.jaas.AbstractJaasValidationCallbackHandler;

public class JaasCertificateValidationCallbackHandler
extends AbstractJaasValidationCallbackHandler {
    protected final void handleInternal(Callback callback) throws UnsupportedCallbackException {
        if (!(callback instanceof CertificateValidationCallback)) {
            throw new UnsupportedCallbackException(callback);
        }
        ((CertificateValidationCallback)callback).setValidator((CertificateValidationCallback.CertificateValidator)new JaasCertificateValidator());
    }

    private class JaasCertificateValidator
    implements CertificateValidationCallback.CertificateValidator {
        private JaasCertificateValidator() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            LoginContext loginContext;
            Subject subject = new Subject();
            subject.getPrincipals().add(certificate.getSubjectX500Principal());
            try {
                loginContext = new LoginContext(JaasCertificateValidationCallbackHandler.this.getLoginContextName(), subject);
            }
            catch (LoginException ex) {
                throw new CertificateValidationCallback.CertificateValidationException((Throwable)ex);
            }
            catch (SecurityException ex) {
                throw new CertificateValidationCallback.CertificateValidationException((Throwable)ex);
            }
            try {
                loginContext.login();
                Subject subj = loginContext.getSubject();
                if (!subj.getPrincipals().isEmpty()) {
                    if (JaasCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                        JaasCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] successful"));
                    }
                    return true;
                }
                if (JaasCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    JaasCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] failed"));
                }
                return false;
            }
            catch (LoginException ex) {
                if (JaasCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    JaasCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] failed"));
                }
                return false;
            }
        }
    }
}

