/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter.method.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import nu.xom.Builder;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.converters.DOMConverter;
import org.springframework.core.MethodParameter;
import org.springframework.ws.server.endpoint.adapter.method.AbstractPayloadSourceMethodProcessor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XomPayloadMethodProcessor
extends AbstractPayloadSourceMethodProcessor {
    private DocumentBuilderFactory documentBuilderFactory = this.createDocumentBuilderFactory();

    protected boolean supportsRequestPayloadParameter(MethodParameter parameter) {
        return this.supports(parameter);
    }

    protected Element resolveRequestPayloadArgument(MethodParameter parameter, Source requestPayload) throws TransformerException, IOException, ParsingException {
        if (requestPayload instanceof DOMSource) {
            Node node = ((DOMSource)requestPayload).getNode();
            if (node.getNodeType() == 1) {
                return DOMConverter.convert((org.w3c.dom.Element)((org.w3c.dom.Element)node));
            }
            if (node.getNodeType() == 9) {
                nu.xom.Document document = DOMConverter.convert((Document)((Document)node));
                return document.getRootElement();
            }
        }
        ByteArrayInputStream bis = this.convertToByteArrayInputStream(requestPayload);
        Builder builder = new Builder();
        nu.xom.Document document = builder.build((InputStream)bis);
        return document.getRootElement();
    }

    protected boolean supportsResponsePayloadReturnType(MethodParameter returnType) {
        return this.supports(returnType);
    }

    protected Source createResponsePayload(MethodParameter returnType, Object returnValue) throws ParserConfigurationException {
        Element returnedElement = (Element)returnValue;
        nu.xom.Document document = returnedElement.getDocument();
        if (document == null) {
            document = new nu.xom.Document(returnedElement);
        }
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        DOMImplementation domImplementation = documentBuilder.getDOMImplementation();
        Document w3cDocument = DOMConverter.convert((nu.xom.Document)document, (DOMImplementation)domImplementation);
        return new DOMSource(w3cDocument);
    }

    private boolean supports(MethodParameter parameter) {
        return Element.class.equals((Object)parameter.getParameterType());
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }
}

