/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j.support;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.Merlin;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CryptoFactoryBean
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean {
    private Properties configuration = new Properties();
    private ClassLoader classLoader;
    private Crypto crypto;
    private static final String CRYPTO_PROVIDER_PROPERTY = "org.apache.ws.security.crypto.provider";

    public void setConfiguration(Properties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        this.configuration.putAll((Map<?, ?>)properties);
    }

    public void setCryptoProvider(Class cryptoProviderClass) {
        this.configuration.setProperty(CRYPTO_PROVIDER_PROPERTY, cryptoProviderClass.getName());
    }

    public void setKeyStoreLocation(Resource location) throws IOException {
        File keystoreFile = location.getFile();
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.file", keystoreFile.getAbsolutePath());
    }

    public void setKeyStoreProvider(String provider) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.provider", provider);
    }

    public void setKeyStorePassword(String password) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", password);
    }

    public void setKeyStoreType(String type) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", type);
    }

    public void setTrustStorePassword(String password) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.cacerts.password", password);
    }

    public void setDefaultX509Alias(String defaultX509Alias) {
        this.configuration.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", defaultX509Alias);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.configuration.containsKey(CRYPTO_PROVIDER_PROPERTY)) {
            this.configuration.setProperty(CRYPTO_PROVIDER_PROPERTY, Merlin.class.getName());
        }
        this.crypto = CryptoFactory.getInstance((Properties)this.configuration, (ClassLoader)this.classLoader);
    }

    public Class getObjectType() {
        return Crypto.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        return this.crypto;
    }
}

