/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapEnvelope;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.axiom.AxiomSoap11Body;
import org.springframework.ws.soap.axiom.AxiomSoap11Header;
import org.springframework.ws.soap.axiom.AxiomSoap12Body;
import org.springframework.ws.soap.axiom.AxiomSoap12Header;
import org.springframework.ws.soap.axiom.AxiomSoapBody;
import org.springframework.ws.soap.axiom.AxiomSoapBodyException;
import org.springframework.ws.soap.axiom.AxiomSoapElement;
import org.springframework.ws.soap.axiom.AxiomSoapEnvelopeException;
import org.springframework.ws.soap.axiom.AxiomSoapHeaderException;

class AxiomSoapEnvelope
extends AxiomSoapElement
implements SoapEnvelope {
    boolean payloadCaching;
    private AxiomSoapBody body;
    private final boolean langAttributeOnSoap11FaulString;

    AxiomSoapEnvelope(SOAPEnvelope axiomEnvelope, SOAPFactory axiomFactory, boolean payloadCaching, boolean langAttributeOnSoap11FaulString) {
        super((OMElement)axiomEnvelope, axiomFactory);
        this.payloadCaching = payloadCaching;
        this.langAttributeOnSoap11FaulString = langAttributeOnSoap11FaulString;
    }

    public SoapHeader getHeader() {
        try {
            if (this.getAxiomEnvelope().getHeader() == null) {
                return null;
            }
            SOAPHeader axiomHeader = this.getAxiomEnvelope().getHeader();
            String namespaceURI = this.getAxiomEnvelope().getNamespace().getNamespaceURI();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
                return new AxiomSoap11Header(axiomHeader, this.getAxiomFactory());
            }
            if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) {
                return new AxiomSoap12Header(axiomHeader, this.getAxiomFactory());
            }
            throw new AxiomSoapEnvelopeException("Unknown SOAP namespace \"" + namespaceURI + "\"");
        }
        catch (OMException ex) {
            throw new AxiomSoapHeaderException(ex);
        }
    }

    public SoapBody getBody() {
        block5: {
            if (this.body == null) {
                try {
                    SOAPBody axiomBody = this.getAxiomEnvelope().getBody();
                    String namespaceURI = this.getAxiomEnvelope().getNamespace().getNamespaceURI();
                    if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
                        this.body = new AxiomSoap11Body(axiomBody, this.getAxiomFactory(), this.payloadCaching, this.langAttributeOnSoap11FaulString);
                        break block5;
                    }
                    if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) {
                        this.body = new AxiomSoap12Body(axiomBody, this.getAxiomFactory(), this.payloadCaching);
                        break block5;
                    }
                    throw new AxiomSoapEnvelopeException("Unknown SOAP namespace \"" + namespaceURI + "\"");
                }
                catch (OMException ex) {
                    throw new AxiomSoapBodyException(ex);
                }
            }
        }
        return this.body;
    }

    protected SOAPEnvelope getAxiomEnvelope() {
        return (SOAPEnvelope)this.getAxiomElement();
    }
}

