/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.adapter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.adapter.AbstractMethodEndpointAdapter;
import org.springframework.ws.server.endpoint.annotation.XPathParam;
import org.springframework.xml.namespace.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathParamAnnotationMethodEndpointAdapter
extends AbstractMethodEndpointAdapter
implements InitializingBean {
    private XPathFactory xpathFactory;
    private Properties namespaces;

    public void setNamespaces(Properties namespaces) {
        this.namespaces = namespaces;
    }

    public void afterPropertiesSet() throws Exception {
        this.xpathFactory = XPathFactory.newInstance();
    }

    @Override
    protected boolean supportsInternal(MethodEndpoint methodEndpoint) {
        Method method = methodEndpoint.getMethod();
        if (!Source.class.isAssignableFrom(method.getReturnType()) && !Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (this.getXPathParamAnnotation(method, i) != null && this.isSuportedType(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    private XPathParam getXPathParamAnnotation(Method method, int paramIdx) {
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int annIdx = 0; annIdx < paramAnnotations[paramIdx].length; ++annIdx) {
            if (!paramAnnotations[paramIdx][annIdx].annotationType().equals(XPathParam.class)) continue;
            return (XPathParam)paramAnnotations[paramIdx][annIdx];
        }
        return null;
    }

    private boolean isSuportedType(Class<?> clazz) {
        return Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Node.class.isAssignableFrom(clazz) || NodeList.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
    }

    @Override
    protected void invokeInternal(MessageContext messageContext, MethodEndpoint methodEndpoint) throws Exception {
        Element payloadElement = this.getRootElement(messageContext.getRequest().getPayloadSource());
        Object[] args = this.getMethodArguments(payloadElement, methodEndpoint.getMethod());
        Object result = methodEndpoint.invoke(args);
        if (result != null && result instanceof Source) {
            Source responseSource = (Source)result;
            WebServiceMessage response = messageContext.getResponse();
            this.transform(responseSource, response.getPayloadResult());
        }
    }

    private Object[] getMethodArguments(Element payloadElement, Method method) throws XPathExpressionException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        XPath xpath = this.createXPath();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            QName conversionType;
            String expression = this.getXPathParamAnnotation(method, i).value();
            if (Boolean.class.isAssignableFrom(parameterTypes[i]) || Boolean.TYPE.isAssignableFrom(parameterTypes[i])) {
                conversionType = XPathConstants.BOOLEAN;
            } else if (Double.class.isAssignableFrom(parameterTypes[i]) || Double.TYPE.isAssignableFrom(parameterTypes[i])) {
                conversionType = XPathConstants.NUMBER;
            } else if (Node.class.isAssignableFrom(parameterTypes[i])) {
                conversionType = XPathConstants.NODE;
            } else if (NodeList.class.isAssignableFrom(parameterTypes[i])) {
                conversionType = XPathConstants.NODESET;
            } else if (String.class.isAssignableFrom(parameterTypes[i])) {
                conversionType = XPathConstants.STRING;
            } else {
                throw new IllegalArgumentException("Invalid parameter type [" + parameterTypes[i] + "]. " + "Supported are: Boolean, Double, Node, NodeList, and String.");
            }
            args[i] = xpath.evaluate(expression, payloadElement, conversionType);
        }
        return args;
    }

    private XPath createXPath() {
        XPath xpath = this.xpathFactory.newXPath();
        if (this.namespaces != null) {
            SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
            namespaceContext.setBindings(this.namespaces);
            xpath.setNamespaceContext(namespaceContext);
        }
        return xpath;
    }

    private Element getRootElement(Source source) throws TransformerException {
        DOMResult domResult = new DOMResult();
        this.transform(source, domResult);
        Document document = (Document)domResult.getNode();
        return document.getDocumentElement();
    }
}

