/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import javax.wsdl.Message;
import org.springframework.ws.wsdl.wsdl11.provider.AbstractPortTypesProvider;

public class SuffixBasedPortTypesProvider
extends AbstractPortTypesProvider {
    public static final String DEFAULT_REQUEST_SUFFIX = "Request";
    public static final String DEFAULT_RESPONSE_SUFFIX = "Response";
    public static final String DEFAULT_FAULT_SUFFIX = "Fault";
    private String requestSuffix = "Request";
    private String responseSuffix = "Response";
    private String faultSuffix = "Fault";

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public void setRequestSuffix(String requestSuffix) {
        this.requestSuffix = requestSuffix;
    }

    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    public void setResponseSuffix(String responseSuffix) {
        this.responseSuffix = responseSuffix;
    }

    public String getFaultSuffix() {
        return this.faultSuffix;
    }

    public void setFaultSuffix(String faultSuffix) {
        this.faultSuffix = faultSuffix;
    }

    protected String getOperationName(Message message) {
        String messageName = this.getMessageName(message);
        if (messageName != null) {
            if (messageName.endsWith(this.getRequestSuffix())) {
                return messageName.substring(0, messageName.length() - this.getRequestSuffix().length());
            }
            if (messageName.endsWith(this.getResponseSuffix())) {
                return messageName.substring(0, messageName.length() - this.getResponseSuffix().length());
            }
            if (messageName.endsWith(this.getFaultSuffix())) {
                return messageName.substring(0, messageName.length() - this.getFaultSuffix().length());
            }
        }
        return null;
    }

    protected boolean isInputMessage(Message message) {
        String messageName = this.getMessageName(message);
        return messageName != null && messageName.endsWith(this.getRequestSuffix());
    }

    protected boolean isOutputMessage(Message message) {
        String messageName = this.getMessageName(message);
        return messageName != null && messageName.endsWith(this.getResponseSuffix());
    }

    protected boolean isFaultMessage(Message message) {
        String messageName = this.getMessageName(message);
        return messageName != null && messageName.endsWith(this.getFaultSuffix());
    }

    private String getMessageName(Message message) {
        return message.getQName().getLocalPart();
    }
}

