/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.IOException;
import java.net.URI;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.util.StringUtils;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.jms.JmsSenderConnection;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

public class JmsMessageSender
extends JmsDestinationAccessor
implements WebServiceMessageSender {
    public static final long DEFAULT_RECEIVE_TIMEOUT = -1L;
    public static final String DEFAULT_TEXT_MESSAGE_ENCODING = "UTF-8";
    private long receiveTimeout = -1L;
    private String textMessageEncoding = "UTF-8";

    public void setTextMessageEncoding(String textMessageEncoding) {
        this.textMessageEncoding = textMessageEncoding;
    }

    public JmsMessageSender() {
    }

    public JmsMessageSender(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public WebServiceConnection createConnection(URI uri) throws IOException {
        Connection jmsConnection = null;
        Session jmsSession = null;
        try {
            jmsConnection = this.createConnection();
            jmsSession = this.createSession(jmsConnection);
            Destination requestDestination = this.resolveRequestDestination(jmsSession, uri);
            Message requestMessage = this.createRequestMessage(jmsSession, uri);
            JmsSenderConnection wsConnection = new JmsSenderConnection(this.getConnectionFactory(), jmsConnection, jmsSession, requestDestination, requestMessage);
            wsConnection.setDeliveryMode(JmsTransportUtils.getDeliveryMode(uri));
            wsConnection.setPriority(JmsTransportUtils.getPriority(uri));
            wsConnection.setReceiveTimeout(this.receiveTimeout);
            wsConnection.setResponseDestination(this.resolveResponseDestination(jmsSession, uri));
            wsConnection.setTimeToLive(JmsTransportUtils.getTimeToLive(uri));
            wsConnection.setTextMessageEncoding(this.textMessageEncoding);
            return wsConnection;
        }
        catch (JMSException ex) {
            JmsUtils.closeSession(jmsSession);
            ConnectionFactoryUtils.releaseConnection((Connection)jmsConnection, (ConnectionFactory)this.getConnectionFactory(), (boolean)true);
            throw new JmsTransportException(ex);
        }
    }

    public boolean supports(URI uri) {
        return uri.getScheme().equals("jms");
    }

    private Destination resolveRequestDestination(Session session, URI uri) throws JMSException {
        return this.resolveDestinationName(session, JmsTransportUtils.getDestinationName(uri));
    }

    private Destination resolveResponseDestination(Session session, URI uri) throws JMSException {
        String destinationName = JmsTransportUtils.getReplyToName(uri);
        return StringUtils.hasLength((String)destinationName) ? this.resolveDestinationName(session, destinationName) : null;
    }

    private Message createRequestMessage(Session session, URI uri) throws JMSException {
        int messageType = JmsTransportUtils.getMessageType(uri);
        if (messageType == 1) {
            return session.createBytesMessage();
        }
        if (messageType == 2) {
            return session.createTextMessage();
        }
        throw new IllegalArgumentException("Invalid message type [" + messageType + "].");
    }
}

