/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.CommonsHttpConnection;

public class CommonsHttpMessageSender
extends AbstractHttpWebServiceMessageSender
implements InitializingBean,
DisposableBean {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 60000;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private HttpClient httpClient;
    private Credentials credentials;
    private AuthScope authScope;

    public CommonsHttpMessageSender() {
        this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.setConnectionTimeout(60000);
        this.setReadTimeout(60000);
    }

    public CommonsHttpMessageSender(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.getHttpClient().getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.getHttpClient().getHttpConnectionManager().getParams().setSoTimeout(timeout);
    }

    public AuthScope getAuthScope() {
        return this.authScope != null ? this.authScope : AuthScope.ANY;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getCredentials() != null) {
            this.getHttpClient().getState().setCredentials(this.getAuthScope(), this.getCredentials());
        }
    }

    public void destroy() throws Exception {
        HttpConnectionManager connectionManager = this.getHttpClient().getHttpConnectionManager();
        if (connectionManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
        }
    }

    public WebServiceConnection createConnection(URI uri) throws IOException {
        PostMethod postMethod = new PostMethod(uri.toString());
        if (this.isAcceptGzipEncoding()) {
            postMethod.addRequestHeader("Accept-Encoding", "gzip");
        }
        return new CommonsHttpConnection(this.getHttpClient(), postMethod);
    }
}

