/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.transform.Result;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapHeaderElement;
import org.springframework.ws.soap.saaj.SaajSoapHeaderException;

abstract class SaajSoapHeader
extends SaajSoapElement
implements SoapHeader {
    SaajSoapHeader(SOAPHeader header) {
        super((SOAPElement)header);
    }

    public Iterator examineAllHeaderElements() throws SoapHeaderException {
        Iterator iterator = this.getImplementation().examineAllHeaderElements(this.getSaajHeader());
        return this.createSaajSoapHeaderElementIterator(iterator);
    }

    public Iterator examineMustUnderstandHeaderElements(String actorOrRole) throws SoapHeaderException {
        Iterator iterator = this.getImplementation().examineMustUnderstandHeaderElements(this.getSaajHeader(), actorOrRole);
        return this.createSaajSoapHeaderElementIterator(iterator);
    }

    public SoapHeaderElement addHeaderElement(QName name) throws SoapHeaderException {
        try {
            SOAPHeaderElement headerElement = this.getImplementation().addHeaderElement(this.getSaajHeader(), name);
            return new SaajSoapHeaderElement(headerElement);
        }
        catch (SOAPException ex) {
            throw new SaajSoapHeaderException(ex);
        }
    }

    public void removeHeaderElement(QName name) throws SoapHeaderException {
        try {
            Iterator iterator = this.getImplementation().getChildElements((SOAPElement)this.getSaajHeader(), name);
            if (iterator.hasNext()) {
                SOAPElement element = (SOAPElement)iterator.next();
                element.detachNode();
            }
        }
        catch (SOAPException ex) {
            throw new SaajSoapHeaderException(ex);
        }
    }

    protected SOAPHeader getSaajHeader() {
        return (SOAPHeader)this.getSaajElement();
    }

    public Result getResult() {
        return this.getImplementation().getResult((SOAPElement)this.getSaajHeader());
    }

    private Iterator createSaajSoapHeaderElementIterator(Iterator iterator) {
        ArrayList result = new ArrayList();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof SOAPHeaderElement)) continue;
            result.add(o);
        }
        return new SaajSoapHeaderElementIterator(result.iterator());
    }

    protected static class SaajSoapHeaderElementIterator
    implements Iterator {
        private final Iterator iterator;

        protected SaajSoapHeaderElementIterator(Iterator iterator) {
            Assert.notNull((Object)iterator, (String)"iterator must not be null");
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            SOAPHeaderElement saajHeaderElement = (SOAPHeaderElement)this.iterator.next();
            return new SaajSoapHeaderElement(saajHeaderElement);
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

