/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j2;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.wss4j.dom.validate.TimestampValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.security.AbstractWsSecurityInterceptor;
import org.springframework.ws.soap.security.WsSecuritySecurementException;
import org.springframework.ws.soap.security.WsSecurityValidationException;
import org.springframework.ws.soap.security.callback.CallbackHandlerChain;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j2.Wss4jHandler;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecuritySecurementException;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecurityValidationException;
import org.springframework.ws.soap.security.wss4j2.callback.UsernameTokenPrincipalCallback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Wss4jSecurityInterceptor
extends AbstractWsSecurityInterceptor
implements InitializingBean {
    public static final String SECUREMENT_USER_PROPERTY_NAME = "Wss4jSecurityInterceptor.securementUser";
    public static final String SECUREMENT_PASSWORD_PROPERTY_NAME = "Wss4jSecurityInterceptor.securementPassword";
    private @Nullable String securementActions;
    private @Nullable String securementUsername;
    private @Nullable CallbackHandler validationCallbackHandler;
    private @Nullable String validationActions;
    private List<Integer> validationActionsVector = Collections.emptyList();
    private @Nullable String validationActor;
    private @Nullable Crypto validationDecryptionCrypto;
    private @Nullable Crypto validationSignatureCrypto;
    private boolean timestampStrict = true;
    private boolean enableSignatureConfirmation;
    private int validationTimeToLive = 300;
    private int securementTimeToLive = 300;
    private int futureTimeToLive = 60;
    private @Nullable WSSConfig wssConfig;
    private final Wss4jHandler handler = new Wss4jHandler();
    private final WSSecurityEngine securityEngine;
    private boolean enableRevocation;
    private boolean bspCompliant;
    private boolean addInclusivePrefixes = true;
    private boolean securementUseDerivedKey;
    private @Nullable CallbackHandler samlCallbackHandler;
    private @Nullable CallbackHandler attachmentCallbackHandler;
    private boolean allowRSA15KeyTransportAlgorithm = true;
    private boolean removeSecurityHeader = true;
    private List<Pattern> signatureSubjectDnPatterns = Collections.emptyList();

    public Wss4jSecurityInterceptor() {
        this.securityEngine = new WSSecurityEngine();
    }

    public Wss4jSecurityInterceptor(WSSecurityEngine securityEngine) {
        this.securityEngine = securityEngine;
    }

    public void setSecurementActions(String securementActions) {
        this.securementActions = securementActions;
    }

    public void setWsHandlerOption(String key, String value) {
        this.handler.setOption(key, value);
    }

    public void setWsHandlerOption(String key, boolean value) {
        this.handler.setOption(key, value);
    }

    public void setSecurementActor(String securementActor) {
        this.setWsHandlerOption("actor", securementActor);
    }

    public void setSecurementEncryptionCrypto(Crypto securementEncryptionCrypto) {
        this.handler.setSecurementEncryptionCrypto(securementEncryptionCrypto);
    }

    public void setSecurementEncryptionKeyIdentifier(String securementEncryptionKeyIdentifier) {
        this.setWsHandlerOption("encryptionKeyIdentifier", securementEncryptionKeyIdentifier);
    }

    public void setSecurementEncryptionKeyTransportAlgorithm(String securementEncryptionKeyTransportAlgorithm) {
        this.setWsHandlerOption("encryptionKeyTransportAlgorithm", securementEncryptionKeyTransportAlgorithm);
    }

    public void setSecurementEncryptionParts(String securementEncryptionParts) {
        this.setWsHandlerOption("encryptionParts", securementEncryptionParts);
    }

    public void setSecurementEncryptionSymAlgorithm(String securementEncryptionSymAlgorithm) {
        this.setWsHandlerOption("encryptionSymAlgorithm", securementEncryptionSymAlgorithm);
    }

    public void setSecurementEncryptionUser(String securementEncryptionUser) {
        this.setWsHandlerOption("encryptionUser", securementEncryptionUser);
    }

    public void setSecurementPassword(String securementPassword) {
        this.handler.setSecurementPassword(securementPassword);
    }

    public void setSecurementPasswordType(String securementUsernameTokenPasswordType) {
        this.setWsHandlerOption("passwordType", securementUsernameTokenPasswordType);
    }

    public void setSecurementSignatureAlgorithm(String securementSignatureAlgorithm) {
        this.setWsHandlerOption("signatureAlgorithm", securementSignatureAlgorithm);
    }

    public void setSecurementSignatureDigestAlgorithm(String digestAlgorithm) {
        this.setWsHandlerOption("signatureDigestAlgorithm", digestAlgorithm);
    }

    public void setSecurementSignatureCrypto(Crypto securementSignatureCrypto) {
        this.handler.setSecurementSignatureCrypto(securementSignatureCrypto);
    }

    public void setSecurementSignatureKeyIdentifier(String securementSignatureKeyIdentifier) {
        this.setWsHandlerOption("signatureKeyIdentifier", securementSignatureKeyIdentifier);
    }

    public void setSecurementSignatureParts(String securementSignatureParts) {
        this.setWsHandlerOption("signatureParts", securementSignatureParts);
    }

    public void setSecurementSignatureUser(String securementSignatureUser) {
        this.setWsHandlerOption("signatureUser", securementSignatureUser);
    }

    public void setSecurementUsername(String securementUsername) {
        this.securementUsername = securementUsername;
    }

    public void setSecurementTimeToLive(int securementTimeToLive) {
        if (securementTimeToLive <= 0) {
            throw new IllegalArgumentException("timeToLive must be positive");
        }
        this.securementTimeToLive = securementTimeToLive;
    }

    public void setSecurementUseDerivedKey(boolean securementUseDerivedKey) {
        this.securementUseDerivedKey = securementUseDerivedKey;
    }

    public void setSecurementSamlCallbackHandler(CallbackHandler samlCallbackHandler) {
        this.samlCallbackHandler = samlCallbackHandler;
    }

    public void setAttachmentCallbackHandler(CallbackHandler attachmentCallbackHandler) {
        this.attachmentCallbackHandler = attachmentCallbackHandler;
    }

    public void setValidationTimeToLive(int validationTimeToLive) {
        if (validationTimeToLive <= 0) {
            throw new IllegalArgumentException("timeToLive must be positive");
        }
        this.validationTimeToLive = validationTimeToLive;
    }

    public void setValidationActions(String actions) {
        this.validationActions = actions;
        try {
            this.validationActionsVector = WSSecurityUtil.decodeAction((String)actions);
        }
        catch (WSSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setValidationActor(String validationActor) {
        this.validationActor = validationActor;
    }

    public void setValidationCallbackHandler(CallbackHandler callbackHandler) {
        this.validationCallbackHandler = callbackHandler;
    }

    public void setValidationCallbackHandlers(CallbackHandler[] callbackHandler) {
        this.validationCallbackHandler = new CallbackHandlerChain(callbackHandler);
    }

    public void setValidationDecryptionCrypto(Crypto decryptionCrypto) {
        this.validationDecryptionCrypto = decryptionCrypto;
    }

    public void setValidationSignatureCrypto(Crypto signatureCrypto) {
        this.validationSignatureCrypto = signatureCrypto;
    }

    public void setValidationSubjectDnConstraints(List<Pattern> patterns) {
        this.signatureSubjectDnPatterns = patterns;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.setWsHandlerOption("enableSignatureConfirmation", enableSignatureConfirmation);
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public void setTimestampPrecisionInMilliseconds(boolean timestampPrecisionInMilliseconds) {
        this.setWsHandlerOption("precisionInMilliseconds", timestampPrecisionInMilliseconds);
    }

    public void setTimestampStrict(boolean timestampStrict) {
        this.timestampStrict = timestampStrict;
    }

    public void setSecurementMustUnderstand(boolean securementMustUnderstand) {
        this.setWsHandlerOption("mustUnderstand", securementMustUnderstand);
    }

    public void setSecurementUsernameTokenNonce(boolean securementUsernameTokenNonce) {
        this.setWsHandlerOption("addUsernameTokenNonce", securementUsernameTokenNonce);
    }

    public void setSecurementUsernameTokenCreated(boolean securementUsernameTokenCreated) {
        this.setWsHandlerOption("addUsernameTokenCreated", securementUsernameTokenCreated);
    }

    public void setWssConfig(WSSConfig config) {
        this.securityEngine.setWssConfig(config);
        this.wssConfig = config;
    }

    public void setEnableRevocation(boolean enableRevocation) {
        this.enableRevocation = enableRevocation;
    }

    public void setBspCompliant(boolean bspCompliant) {
        this.setWsHandlerOption("isBSPCompliant", bspCompliant);
        this.bspCompliant = bspCompliant;
    }

    public void setAddInclusivePrefixes(boolean addInclusivePrefixes) {
        this.setWsHandlerOption("addInclusivePrefixes", addInclusivePrefixes);
        this.addInclusivePrefixes = addInclusivePrefixes;
    }

    public void setUseSingleCertificate(boolean useSingleCertificate) {
        this.setWsHandlerOption("useSingleCertificate", useSingleCertificate);
    }

    public void setAllowRSA15KeyTransportAlgorithm(boolean allow) {
        this.allowRSA15KeyTransportAlgorithm = allow;
    }

    public void setFutureTimeToLive(int futureTimeToLive) {
        if (futureTimeToLive <= 0) {
            throw new IllegalArgumentException("futureTimeToLive must be positive");
        }
        this.futureTimeToLive = futureTimeToLive;
    }

    public boolean getRemoveSecurityHeader() {
        return this.removeSecurityHeader;
    }

    public void setRemoveSecurityHeader(boolean removeSecurityHeader) {
        this.removeSecurityHeader = removeSecurityHeader;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.validationActions != null || this.securementActions != null ? 1 : 0) != 0, (String)"validationActions or securementActions are required");
        if (this.validationActions != null) {
            if (this.validationActionsVector.contains(1)) {
                Assert.notNull((Object)this.validationCallbackHandler, (String)"validationCallbackHandler is required");
            }
            if (this.validationActionsVector.contains(2)) {
                Assert.notNull((Object)this.validationSignatureCrypto, (String)"validationSignatureCrypto is required");
            }
        }
    }

    @Override
    protected void secureMessage(SoapMessage soapMessage, MessageContext messageContext) throws WsSecuritySecurementException {
        List securementActionsVector;
        try {
            securementActionsVector = WSSecurityUtil.decodeHandlerAction((String)this.securementActions, (WSSConfig)this.wssConfig);
        }
        catch (WSSecurityException ex) {
            throw new Wss4jSecuritySecurementException(ex.getMessage(), ex);
        }
        if (securementActionsVector.isEmpty() && !this.enableSignatureConfirmation) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Securing message [" + String.valueOf(soapMessage) + "] with actions [" + this.securementActions + "]"));
        }
        RequestData requestData = this.initializeRequestData(messageContext);
        Document envelopeAsDocument = soapMessage.getDocument();
        try {
            this.handler.doSenderAction(envelopeAsDocument, requestData, securementActionsVector, false);
        }
        catch (WSSecurityException ex) {
            throw new Wss4jSecuritySecurementException(ex.getMessage(), ex);
        }
        soapMessage.setDocument(envelopeAsDocument);
    }

    protected RequestData initializeRequestData(MessageContext messageContext) {
        RequestData requestData = new RequestData();
        requestData.setMsgContext((Object)messageContext);
        String contextUsername = (String)messageContext.getProperty(SECUREMENT_USER_PROPERTY_NAME);
        if (StringUtils.hasLength((String)contextUsername)) {
            requestData.setUsername(contextUsername);
        } else {
            requestData.setUsername(this.securementUsername);
        }
        requestData.setTimeStampTTL(this.securementTimeToLive);
        requestData.setUseDerivedKeyForMAC(this.securementUseDerivedKey);
        requestData.setWssConfig(this.wssConfig);
        messageContext.setProperty("timeToLive", (Object)Integer.toString(this.securementTimeToLive));
        if (this.samlCallbackHandler != null) {
            messageContext.setProperty("samlCallbackRef", (Object)this.samlCallbackHandler);
        }
        if (this.attachmentCallbackHandler != null) {
            requestData.setAttachmentCallbackHandler(this.attachmentCallbackHandler);
        }
        requestData.setAllowNamespaceQualifiedPasswordTypes(true);
        requestData.setSubjectCertConstraints(this.signatureSubjectDnPatterns);
        return requestData;
    }

    protected RequestData initializeValidationRequestData(MessageContext messageContext) {
        RequestData requestData = new RequestData();
        requestData.setMsgContext((Object)messageContext);
        requestData.setWssConfig(this.wssConfig);
        requestData.setDecCrypto(this.validationDecryptionCrypto);
        requestData.setSigVerCrypto(this.validationSignatureCrypto);
        requestData.setCallbackHandler(this.validationCallbackHandler);
        messageContext.setProperty("timestampStrict", (Object)this.timestampStrict);
        messageContext.setProperty("timeToLive", (Object)Integer.toString(this.validationTimeToLive));
        messageContext.setProperty("futureTimeToLive", (Object)Integer.toString(this.futureTimeToLive));
        requestData.setTimeStampStrict(this.timestampStrict);
        requestData.setTimeStampTTL(this.validationTimeToLive);
        requestData.setTimeStampFutureTTL(this.futureTimeToLive);
        requestData.setAllowRSA15KeyTransportAlgorithm(this.allowRSA15KeyTransportAlgorithm);
        requestData.setDisableBSPEnforcement(!this.bspCompliant);
        if (requestData.getBSPEnforcer() != null) {
            requestData.getBSPEnforcer().setDisableBSPRules(!this.bspCompliant);
        }
        requestData.setAddInclusivePrefixes(this.addInclusivePrefixes);
        requestData.setAllowNamespaceQualifiedPasswordTypes(true);
        requestData.setSubjectCertConstraints(this.signatureSubjectDnPatterns);
        return requestData;
    }

    @Override
    protected void validateMessage(SoapMessage soapMessage, MessageContext messageContext) throws WsSecurityValidationException {
        SoapHeader header;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Validating message [" + String.valueOf(soapMessage) + "] with actions [" + this.validationActions + "]"));
        }
        if (CollectionUtils.isEmpty(this.validationActionsVector)) {
            return;
        }
        Document envelopeAsDocument = soapMessage.getDocument();
        try {
            Element elem;
            WSHandlerResult result;
            RequestData validationData = this.initializeValidationRequestData(messageContext);
            String actor = this.validationActor;
            if (actor == null) {
                actor = "";
            }
            if (CollectionUtils.isEmpty((Collection)(result = this.securityEngine.processSecurityHeader(elem = WSSecurityUtil.getSecurityHeader((Document)envelopeAsDocument, (String)actor), validationData)).getResults())) {
                throw new Wss4jSecurityValidationException("No WS-Security header found");
            }
            this.checkResults(result.getResults(), this.validationActionsVector);
            this.updateContextWithResults(messageContext, result.getResults());
            this.verifyCertificateTrust(result);
            this.verifyTimestamp(result);
            this.processPrincipal(result);
        }
        catch (WSSecurityException ex) {
            throw new Wss4jSecurityValidationException(ex.getMessage(), ex);
        }
        soapMessage.setDocument(envelopeAsDocument);
        if (this.getRemoveSecurityHeader() && (header = soapMessage.getEnvelope().getHeader()) != null) {
            header.removeHeaderElement(WS_SECURITY_NAME);
        }
    }

    protected void checkResults(List<WSSecurityEngineResult> results, List<Integer> validationActions) throws Wss4jSecurityValidationException {
        if (!this.handler.checkReceiverResultsAnyOrder(results, validationActions)) {
            throw new Wss4jSecurityValidationException("Security processing failed (actions mismatch)");
        }
    }

    private void updateContextWithResults(MessageContext messageContext, List<WSSecurityEngineResult> results) {
        ArrayList<WSHandlerResult> handlerResults = (ArrayList<WSHandlerResult>)messageContext.getProperty("RECV_RESULTS");
        if (handlerResults == null) {
            handlerResults = new ArrayList<WSHandlerResult>();
            messageContext.setProperty("RECV_RESULTS", handlerResults);
        }
        WSHandlerResult rResult = new WSHandlerResult(this.validationActor, results, Collections.emptyMap());
        handlerResults.add(0, rResult);
        messageContext.setProperty("RECV_RESULTS", handlerResults);
    }

    protected void verifyCertificateTrust(WSHandlerResult result) throws WSSecurityException {
        List results = (List)result.getActionResults().get(2);
        if (!CollectionUtils.isEmpty((Collection)results)) {
            Validator validator;
            WSSecurityEngineResult actionResult = (WSSecurityEngineResult)results.get(0);
            X509Certificate returnCert = (X509Certificate)actionResult.get((Object)"x509-certificate");
            Credential credential = new Credential();
            credential.setCertificates(new X509Certificate[]{returnCert});
            RequestData requestData = new RequestData();
            requestData.setSigVerCrypto(this.validationSignatureCrypto);
            requestData.setEnableRevocation(this.enableRevocation);
            requestData.setSubjectCertConstraints(this.signatureSubjectDnPatterns);
            Validator validator2 = validator = this.wssConfig != null ? this.wssConfig.getValidator(WSConstants.SIGNATURE) : null;
            if (validator == null) {
                validator = new SignatureTrustValidator();
            }
            validator.validate(credential, requestData);
        }
    }

    protected void verifyTimestamp(WSHandlerResult result) throws WSSecurityException {
        WSSecurityEngineResult actionResult;
        Timestamp timestamp;
        List results = (List)result.getActionResults().get(32);
        if (!CollectionUtils.isEmpty((Collection)results) && (timestamp = (Timestamp)(actionResult = (WSSecurityEngineResult)results.get(0)).get((Object)"timestamp")) != null && this.timestampStrict) {
            Credential credential = new Credential();
            credential.setTimestamp(timestamp);
            RequestData requestData = new RequestData();
            requestData.setWssConfig(WSSConfig.getNewInstance());
            requestData.setTimeStampTTL(this.validationTimeToLive);
            requestData.setTimeStampStrict(this.timestampStrict);
            requestData.setTimeStampFutureTTL(this.futureTimeToLive);
            TimestampValidator validator = new TimestampValidator();
            validator.validate(credential, requestData);
        }
    }

    private void processPrincipal(WSHandlerResult result) {
        WSSecurityEngineResult actionResult;
        Principal principal;
        List results = (List)result.getActionResults().get(1);
        if (!CollectionUtils.isEmpty((Collection)results) && (principal = (Principal)(actionResult = (WSSecurityEngineResult)results.get(0)).get((Object)"principal")) instanceof WSUsernameTokenPrincipalImpl) {
            WSUsernameTokenPrincipalImpl usernameTokenPrincipal = (WSUsernameTokenPrincipalImpl)principal;
            UsernameTokenPrincipalCallback callback = new UsernameTokenPrincipalCallback(usernameTokenPrincipal);
            try {
                Objects.requireNonNull(this.validationCallbackHandler).handle(new Callback[]{callback});
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Principal callback resulted in IOException", (Throwable)ex);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void cleanUp() {
        if (this.validationCallbackHandler != null) {
            try {
                CleanupCallback cleanupCallback = new CleanupCallback();
                this.validationCallbackHandler.handle(new Callback[]{cleanupCallback});
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Cleanup callback resulted in IOException", (Throwable)ex);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                // empty catch block
            }
        }
    }
}

