/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.security;

import java.util.function.Function;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.execution.EnterStateVetoException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.security.SecurityRule;

public class SecurityFlowExecutionListener
implements FlowExecutionListener {
    private Function<SecurityRule, AuthorizationManager<Object>> authorizationManagerInitializer = SecurityRule::getAuthorizationManager;

    public void setAuthorizationManagerInitializer(Function<SecurityRule, AuthorizationManager<Object>> initializer) {
        Assert.notNull(initializer, (String)"'initializer' is required");
        this.authorizationManagerInitializer = initializer;
    }

    @Override
    public void sessionCreating(RequestContext context, FlowDefinition definition) {
        SecurityRule rule = (SecurityRule)definition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, definition);
        }
    }

    @Override
    public void stateEntering(RequestContext context, StateDefinition state) throws EnterStateVetoException {
        SecurityRule rule = (SecurityRule)state.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, state);
        }
    }

    @Override
    public void transitionExecuting(RequestContext context, TransitionDefinition transition) {
        SecurityRule rule = (SecurityRule)transition.getAttributes().get("secured");
        if (rule != null) {
            this.decide(rule, transition);
        }
    }

    protected void decide(SecurityRule rule, Object object) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AuthorizationManager<Object> manager = this.authorizationManagerInitializer.apply(rule);
        manager.verify(() -> authentication, object);
    }
}

